package org.jboss.hal.client.configuration.subsystem.distributableweb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DistributableWebView extends DistributableWebView {

    private final Metadata metadata99;
    private final Metadata metadata100;
    private final Metadata metadata101;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DistributableWebView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/hotrod-single-sign-on-management=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/infinispan-single-sign-on-management=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("dw-configuration-form", metadata99)
            .onSave((form, changedValues) -> saveSingletonForm("Distributable Web", metadata99Template.resolve(statementContext()), changedValues, metadata99))
            .prepareReset(form -> resetSingletonForm("Distributable Web", metadata99Template.resolve(statementContext()), form, metadata99))
            .build();
        hotRodSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-form", metadata100)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Hotrod Single Sign On Management", name, metadata100Template.resolve(statementContext(), name), changedValues, metadata100);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Hotrod Single Sign On Management", name, metadata100Template.resolve(statementContext(), name), form, metadata100);
            })
            .build();
        infinispanSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-form", metadata101)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Infinispan Single Sign On Management", name, metadata101Template.resolve(statementContext(), name), changedValues, metadata101);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Infinispan Single Sign On Management", name, metadata101Template.resolve(statementContext(), name), form, metadata101);
            })
            .build();

        hotRodSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-table", metadata100)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-hotrod-sso-management-table", Ids.ADD), "Hotrod Single Sign On Management",
                metadata100Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Hotrod Single Sign On Management", metadata100Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        infinispanSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-table", metadata101)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-infinispan-sso-management-table", Ids.ADD), "Infinispan Single Sign On Management",
                metadata101Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Infinispan Single Sign On Management", metadata101Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html299;
        HTMLElement dwConfigurationItemElement = section()
            .add(html299 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Distributable Web</h1><p>${metadata99.getDescription().getDescription()}</p>"))
                            .get())
            .add(configurationForm)
                    .get();
        expressionElements.put("html299", html299);
        navigation.addPrimary("dw-configuration-item", "Configuration", "pficon pficon-settings", dwConfigurationItemElement);
        HTMLElement html301;
        HTMLElement dwHotrodSsoManagementItemElement = section()
            .add(html301 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HotRod SSO Management</h1><p>${metadata100.getDescription().getDescription()}</p>"))
                            .get())
            .add(hotRodSSOManagementTable)
            .add(hotRodSSOManagementForm)
                    .get();
        expressionElements.put("html301", html301);
        navigation.addPrimary("dw-hotrod-sso-management-item", "HotRod SSO", "fa fa-lock", dwHotrodSsoManagementItemElement);
        HTMLElement html304;
        HTMLElement dwInfinispanSsoManagementItemElement = section()
            .add(html304 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Infinispan SSO Management</h1><p>${metadata101.getDescription().getDescription()}</p>"))
                            .get())
            .add(infinispanSSOManagementTable)
            .add(infinispanSSOManagementForm)
                    .get();
        expressionElements.put("html304", html304);
        navigation.addPrimary("dw-infinispan-sso-management-item", "Infinispan SSO", "fa fa-lock", dwInfinispanSsoManagementItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .get();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(hotRodSSOManagementTable);
        registerAttachable(hotRodSSOManagementForm);
        registerAttachable(infinispanSSOManagementTable);
        registerAttachable(infinispanSSOManagementForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hotRodSSOManagementTable.bindForm(hotRodSSOManagementForm);
            infinispanSSOManagementTable.bindForm(infinispanSSOManagementForm);

        TemplateUtil.replaceExpression(expressionElements.get("html299"), "${metadata99.getDescription().getDescription()}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html301"), "${metadata100.getDescription().getDescription()}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html304"), "${metadata101.getDescription().getDescription()}", String.valueOf(metadata101.getDescription().getDescription()));
    }
}
