package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_UndertowSubsystemView extends UndertowSubsystemView {

    private final Metadata metadata72;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_UndertowSubsystemView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        this.expressionElements = new HashMap<>();

        form = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("undertow-global-settings-form", metadata72)
            .include("default-security-domain", "default-server", "default-servlet-container", "default-virtual-host", "instance-id", "statistics-enabled")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Undertow Configuration", metadata72Template.resolve(statementContext()), changedValues, metadata72))
            .prepareReset(form -> resetSingletonForm("Undertow Configuration", metadata72Template.resolve(statementContext()), form, metadata72))
            .build();
        form.getFormItem("default-security-domain").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*")));
        form.getFormItem("default-server").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*")));
        form.getFormItem("default-servlet-container").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/servlet-container=*")));
        form.getFormItem("default-virtual-host").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/host=*")));


        HTMLElement html206;
        HTMLElement root = row()
            .add(column()
                .add(html206 = div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Undertow Configuration</h1><p>${metadata72.getDescription().getDescription()}</p>"))
                        .get())
                                .add(form)
                )
                .get();
        expressionElements.put("html206", html206);

        registerAttachable(form);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        ExpressionUtil.replaceExpression(expressionElements.get("html206"), "${metadata72.getDescription().getDescription()}", String.valueOf(metadata72.getDescription().getDescription()));
    }
}
