package org.jboss.hal.client.configuration.subsystem.transaction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_TransactionView extends TransactionView {

    private final Metadata metadata137;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_TransactionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata137Template = AddressTemplate.of("/{selected.profile}/subsystem=transactions");
        this.metadata137 = mbuiContext.metadataRegistry().lookup(metadata137Template);
        this.expressionElements = new HashMap<>();

        attributesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-attributes-form", metadata137)
            .include("default-timeout", "enable-tsm-status", "journal-store-enable-async-io", "jts", "maximum-timeout", "node-identifier", "statistics-enabled", "use-journal-store")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Transaction Manager", metadata137Template.resolve(statementContext()), changedValues, metadata137))
            .prepareReset(form -> resetSingletonForm("Transaction Manager", metadata137Template.resolve(statementContext()), form, metadata137))
            .build();
        processForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-process-form", metadata137)
            .include("process-id-uuid", "process-id-socket-binding", "process-id-socket-max-ports")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Process ID", metadata137Template.resolve(statementContext()), changedValues, metadata137))
            .prepareReset(form -> resetSingletonForm("Process ID", metadata137Template.resolve(statementContext()), form, metadata137))
            .build();
        processForm.getFormItem("process-id-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-recovery-form", metadata137)
            .include("socket-binding", "status-socket-binding", "recovery-listener")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Recovery", metadata137Template.resolve(statementContext()), changedValues, metadata137))
            .prepareReset(form -> resetSingletonForm("Recovery", metadata137Template.resolve(statementContext()), form, metadata137))
            .build();
        recoveryForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm.getFormItem("status-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        pathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-path-form", metadata137)
            .include("object-store-path", "object-store-relative-to")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Path", metadata137Template.resolve(statementContext()), changedValues, metadata137))
            .prepareReset(form -> resetSingletonForm("Path", metadata137Template.resolve(statementContext()), form, metadata137))
            .build();
        pathForm.getFormItem("object-store-relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        jdbcForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-jdbc-form", metadata137)
            .include("use-jdbc-store", "jdbc-action-store-drop-table", "jdbc-action-store-table-prefix", "jdbc-communication-store-drop-table", "jdbc-communication-store-table-prefix", "jdbc-state-store-drop-table", "jdbc-state-store-table-prefix", "jdbc-store-datasource")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("JDBC", metadata137Template.resolve(statementContext()), changedValues, metadata137))
            .prepareReset(form -> resetSingletonForm("JDBC", metadata137Template.resolve(statementContext()), form, metadata137))
            .build();
        List<AddressTemplate> jdbcFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        jdbcForm.getFormItem("jdbc-store-datasource").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), jdbcFormTemplates));


        navigation = new VerticalNavigation();
        HTMLElement html402;
        HTMLElement txAttributesConfigItemElement = section()
            .add(html402 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Transaction Manager</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                            .get())
            .add(attributesForm)
                    .get();
        expressionElements.put("html402", html402);
        navigation.addPrimary("tx-attributes-config-item", "Configuration", "pficon pficon-settings", txAttributesConfigItemElement);
        HTMLElement html404;
        HTMLElement txProcessItemElement = section()
            .add(html404 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process ID</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                            .get())
            .add(processForm)
                    .get();
        expressionElements.put("html404", html404);
        navigation.addPrimary("tx-process-item", "Process", "pficon pficon-service", txProcessItemElement);
        HTMLElement html406;
        HTMLElement txRecoveryConfigItemElement = section()
            .add(html406 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Recovery</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                            .get())
            .add(recoveryForm)
                    .get();
        expressionElements.put("html406", html406);
        navigation.addPrimary("tx-recovery-config-item", "Recovery", "fa fa-repeat", txRecoveryConfigItemElement);
        HTMLElement html408;
        HTMLElement txPathConfigItemElement = section()
            .add(html408 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Path</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                            .get())
            .add(pathForm)
                    .get();
        expressionElements.put("html408", html408);
        navigation.addPrimary("tx-path-config-item", "Path", "fa fa-folder-open", txPathConfigItemElement);
        HTMLElement html410;
        HTMLElement txJdbcConfigItemElement = section()
            .add(html410 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                            .get())
            .add(jdbcForm)
                    .get();
        expressionElements.put("html410", html410);
        navigation.addPrimary("tx-jdbc-config-item", "JDBC", "fa fa-database", txJdbcConfigItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .get();

        registerAttachable(navigation);
        registerAttachable(attributesForm);
        registerAttachable(processForm);
        registerAttachable(recoveryForm);
        registerAttachable(pathForm);
        registerAttachable(jdbcForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        ExpressionUtil.replaceExpression(expressionElements.get("html402"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html404"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html406"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html408"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html410"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
    }
}
