package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata46;
    private final Metadata metadata43;
    private final Metadata metadata41;
    private final Metadata metadata45;
    private final Metadata metadata44;
    private final Metadata metadata38;
    private final Metadata metadata42;
    private final Metadata metadata36;
    private final Metadata metadata40;
    private final Metadata metadata35;
    private final Metadata metadata39;
    private final Metadata metadata37;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata46Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata46 = mbuiContext.metadataRegistry().lookup(metadata46Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        AddressTemplate metadata45Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata45 = mbuiContext.metadataRegistry().lookup(metadata45Template);
        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        AddressTemplate metadata38Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata38 = mbuiContext.metadataRegistry().lookup(metadata38Template);
        AddressTemplate metadata42Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=identity");
        this.metadata42 = mbuiContext.metadataRegistry().lookup(metadata42Template);
        AddressTemplate metadata36Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata36 = mbuiContext.metadataRegistry().lookup(metadata36Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        AddressTemplate metadata37Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-configuration-form", metadata35)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata35Template.resolve(statementContext()), changedValues, metadata35))
            .prepareReset(form -> resetSingletonForm("Container", metadata35Template.resolve(statementContext()), form, metadata35))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-form", metadata36)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata36Template.resolve(statementContext(), name), changedValues, metadata36);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata36Template.resolve(statementContext(), name), form, metadata36);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-form", metadata37)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata37Template.resolve(statementContext(), name), changedValues, metadata37);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Remoting Profile", name, metadata37Template.resolve(statementContext(), name), form, metadata37);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-form", metadata38)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata38Template.resolve(statementContext(), name), changedValues, metadata38);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Bean Pool", name, metadata38Template.resolve(statementContext(), name), form, metadata38);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-form", metadata39)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata39Template.resolve(statementContext(), name), changedValues, metadata39);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Cache", name, metadata39Template.resolve(statementContext(), name), form, metadata39);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-form", metadata40)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata40Template.resolve(statementContext(), name), changedValues, metadata40);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Passivation", name, metadata40Template.resolve(statementContext(), name), form, metadata40);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-async-form", metadata41)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata41Template.resolve(statementContext()), changedValues, metadata41))
            .prepareReset(form -> resetSingletonForm("Async", metadata41Template.resolve(statementContext()), form, metadata41))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIdentityForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-identity-form", metadata42)
            .singleton(
                () -> new Operation.Builder(metadata42Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-identity-form", "Identity", metadata42Template))
            .prepareRemove(form -> removeSingletonForm("Identity", metadata42Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Identity", metadata42Template.resolve(statementContext()), changedValues, metadata42))
            .prepareReset(form -> resetSingletonForm("Identity", metadata42Template.resolve(statementContext()), form, metadata42))
            .build();
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-iiop-form", metadata43)
            .singleton(
                () -> new Operation.Builder(metadata43Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-iiop-form", "IIOP", metadata43Template))
            .prepareRemove(form -> removeSingletonForm("IIOP", metadata43Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata43Template.resolve(statementContext()), changedValues, metadata43))
            .prepareReset(form -> resetSingletonForm("IIOP", metadata43Template.resolve(statementContext()), form, metadata43))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-remote-form", metadata44)
            .include("cluster", "connectors", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata44Template.resolve(statementContext()), changedValues, metadata44))
            .prepareReset(form -> resetSingletonForm("Remote", metadata44Template.resolve(statementContext()), form, metadata44))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
        List<AddressTemplate> serviceRemoteFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*"));
        serviceRemoteForm.getFormItem("connectors").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), serviceRemoteFormTemplates));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-timer-form", metadata45)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata45Template.resolve(statementContext()), changedValues, metadata45))
            .prepareReset(form -> resetSingletonForm("Timer", metadata45Template.resolve(statementContext()), form, metadata45))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-form", metadata46)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata46Template.resolve(statementContext(), name), changedValues, metadata46);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("MDB Delivery Group", name, metadata46Template.resolve(statementContext(), name), form, metadata46);
            })
            .build();

        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-table", metadata36)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata36Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata36Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-table", metadata37)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-remoting-profile-table", Ids.ADD), "Remoting Profile",
                metadata37Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata37Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-table", metadata38)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-bean-pool-table", Ids.ADD), "Bean Pool",
                metadata38Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata38Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-table", metadata39)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-cache-table", Ids.ADD), "Cache",
                metadata39Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata39Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-table", metadata40)
            .button(mbuiContext.tableButtonFactory().add(metadata40Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb3-passivation-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata40,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata40Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata40Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-table", metadata46)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-mdb-delivery-group-table", Ids.ADD), "MDB Delivery Group",
                metadata46Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata46Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb3-container-item", "Container", "fa fa-cogs");
        HTMLElement html105;
        HTMLElement ejb3ConfigurationItemElement = section()
            .add(html105 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>${metadata35.getDescription().getDescription()}</p>"))
                                    .element())
            .add(configurationForm)
                            .element();
        expressionElements.put("html105", html105);
        navigation.addSecondary("ejb3-container-item", "ejb3-configuration-item", "Container", ejb3ConfigurationItemElement);
        HTMLElement html107;
        HTMLElement ejb3ThreadPoolItemElement = section()
            .add(html107 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata36.getDescription().getDescription()}</p>"))
                                    .element())
            .add(threadPoolTable)
            .add(threadPoolForm)
                            .element();
        expressionElements.put("html107", html107);
        navigation.addSecondary("ejb3-container-item", "ejb3-thread-pool-item", "Thread Pool", ejb3ThreadPoolItemElement);
        HTMLElement html110;
        HTMLElement ejb3RemotingProfileItemElement = section()
            .add(html110 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>${metadata37.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remotingProfileTable)
            .add(remotingProfileForm)
                            .element();
        expressionElements.put("html110", html110);
        navigation.addSecondary("ejb3-container-item", "ejb3-remoting-profile-item", "Remoting Profile", ejb3RemotingProfileItemElement);
        HTMLElement html113;
        HTMLElement ejb3BeanPoolItemElement = section()
            .add(html113 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>${metadata38.getDescription().getDescription()}</p>"))
                            .element())
            .add(beanPoolTable)
            .add(beanPoolForm)
                    .element();
        expressionElements.put("html113", html113);
        navigation.addPrimary("ejb3-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejb3BeanPoolItemElement);
        navigation.addPrimary("ejb3-state-item", "State Management", "fa fa-list-ul");
        HTMLElement html116;
        HTMLElement ejb3CacheItemElement = section()
            .add(html116 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>${metadata39.getDescription().getDescription()}</p>"))
                                    .element())
            .add(cacheTable)
            .add(cacheForm)
                            .element();
        expressionElements.put("html116", html116);
        navigation.addSecondary("ejb3-state-item", "ejb3-cache-item", "Cache", ejb3CacheItemElement);
        HTMLElement html119;
        HTMLElement ejb3PassivationItemElement = section()
            .add(html119 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>${metadata40.getDescription().getDescription()}</p>"))
                                    .element())
            .add(passivationTable)
            .add(passivationForm)
                            .element();
        expressionElements.put("html119", html119);
        navigation.addSecondary("ejb3-state-item", "ejb3-passivation-item", "Passivation", ejb3PassivationItemElement);
        navigation.addPrimary("ejb3-service-item", "Services", "pficon pficon-service");
        HTMLElement html122;
        HTMLElement ejb3ServiceAsyncItemElement = section()
            .add(html122 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>${metadata41.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceAsyncForm)
                            .element();
        expressionElements.put("html122", html122);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-async-item", "Async", ejb3ServiceAsyncItemElement);
        HTMLElement html124;
        HTMLElement ejb3ServiceIdentityItemElement = section()
            .add(html124 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Identity</h1><p>${metadata42.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceIdentityForm)
                            .element();
        expressionElements.put("html124", html124);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-identity-item", "Identity", ejb3ServiceIdentityItemElement);
        HTMLElement html126;
        HTMLElement ejb3ServiceIiopItemElement = section()
            .add(html126 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>${metadata43.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceIiopForm)
                            .element();
        expressionElements.put("html126", html126);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-iiop-item", "IIOP", ejb3ServiceIiopItemElement);
        HTMLElement html128;
        HTMLElement ejb3ServiceRemoteItemElement = section()
            .add(html128 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>${metadata44.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceRemoteForm)
                            .element();
        expressionElements.put("html128", html128);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-remote-item", "Remote", ejb3ServiceRemoteItemElement);
        HTMLElement html130;
        HTMLElement ejb3ServiceTimerItemElement = section()
            .add(html130 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>${metadata45.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceTimerForm)
                            .element();
        expressionElements.put("html130", html130);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-timer-item", "Timer", ejb3ServiceTimerItemElement);
        HTMLElement html132;
        HTMLElement ejb3MdbDeliveryGroupItemElement = section()
            .add(html132 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                            .element())
            .add(mdbDeliveryGroupTable)
            .add(mdbDeliveryGroupForm)
                    .element();
        expressionElements.put("html132", html132);
        navigation.addPrimary("ejb3-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejb3MdbDeliveryGroupItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIdentityForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html105"), "${metadata35.getDescription().getDescription()}", String.valueOf(metadata35.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html107"), "${metadata36.getDescription().getDescription()}", String.valueOf(metadata36.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html110"), "${metadata37.getDescription().getDescription()}", String.valueOf(metadata37.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html113"), "${metadata38.getDescription().getDescription()}", String.valueOf(metadata38.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html116"), "${metadata39.getDescription().getDescription()}", String.valueOf(metadata39.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html119"), "${metadata40.getDescription().getDescription()}", String.valueOf(metadata40.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html122"), "${metadata41.getDescription().getDescription()}", String.valueOf(metadata41.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html124"), "${metadata42.getDescription().getDescription()}", String.valueOf(metadata42.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html126"), "${metadata43.getDescription().getDescription()}", String.valueOf(metadata43.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html128"), "${metadata44.getDescription().getDescription()}", String.valueOf(metadata44.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html130"), "${metadata45.getDescription().getDescription()}", String.valueOf(metadata45.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html132"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
    }
}
