package org.jboss.hal.client.configuration.subsystem.coremanagement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_CoreManagementView extends CoreManagementView {

    private final Metadata metadata143;
    private final Metadata metadata144;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_CoreManagementView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata143Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/service=configuration-changes");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata144Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/process-state-listener=*");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        this.expressionElements = new HashMap<>();

        confChangesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("core-mgmt-conf-change-form", metadata143)
            .singleton(
                () -> new Operation.Builder(metadata143Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> presenter.addConfigurationChanges())
            .prepareRemove(form -> removeSingletonForm("Configuration Changes", metadata143Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Configuration Changes", metadata143Template.resolve(statementContext()), changedValues, metadata143))
            .prepareReset(form -> resetSingletonForm("Configuration Changes", metadata143Template.resolve(statementContext()), form, metadata143))
            .build();
        prcStateListenerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-form", metadata144)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Process State Listeners", name, metadata144Template.resolve(statementContext(), name), changedValues, metadata144);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Process State Listeners", name, metadata144Template.resolve(statementContext(), name), form, metadata144);
            })
            .build();

        prcStateListenerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-table", metadata144)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("core-mgmt-prc-state-table", Ids.ADD), "Process State Listeners",
                metadata144Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Process State Listeners", metadata144Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html430;
        HTMLElement coreMgmtConfChangeItemElement = section()
            .add(html430 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration Changes</h1><p>${metadata143.getDescription().getDescription()}</p>"))
                            .element())
            .add(confChangesForm)
                    .element();
        expressionElements.put("html430", html430);
        navigation.addPrimary("core-mgmt-conf-change-item", "Configuration Changes", "pficon pficon-settings", coreMgmtConfChangeItemElement);
        HTMLElement html432;
        HTMLElement coreMgmtPrcStateItemElement = section()
            .add(html432 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process State Listeners</h1><p>${metadata144.getDescription().getDescription()}</p>"))
                            .element())
            .add(prcStateListenerTable)
            .add(prcStateListenerForm)
                    .element();
        expressionElements.put("html432", html432);
        navigation.addPrimary("core-mgmt-prc-state-item", "Process State Listeners", "pficon pficon-memory", coreMgmtPrcStateItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(confChangesForm);
        registerAttachable(prcStateListenerTable);
        registerAttachable(prcStateListenerForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        ExpressionUtil.replaceExpression(expressionElements.get("html430"), "${metadata143.getDescription().getDescription()}", String.valueOf(metadata143.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html432"), "${metadata144.getDescription().getDescription()}", String.valueOf(metadata144.getDescription().getDescription()));
    }
}
