package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata11;
    private final Metadata metadata8;
    private final Metadata metadata6;
    private final Metadata metadata10;
    private final Metadata metadata9;
    private final Metadata metadata3;
    private final Metadata metadata7;
    private final Metadata metadata1;
    private final Metadata metadata5;
    private final Metadata metadata0;
    private final Metadata metadata4;
    private final Metadata metadata2;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata3Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata3 = mbuiContext.metadataRegistry().lookup(metadata3Template);
        AddressTemplate metadata7Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=identity");
        this.metadata7 = mbuiContext.metadataRegistry().lookup(metadata7Template);
        AddressTemplate metadata1Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata1 = mbuiContext.metadataRegistry().lookup(metadata1Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        AddressTemplate metadata0Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata0 = mbuiContext.metadataRegistry().lookup(metadata0Template);
        AddressTemplate metadata4Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata4 = mbuiContext.metadataRegistry().lookup(metadata4Template);
        AddressTemplate metadata2Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata2 = mbuiContext.metadataRegistry().lookup(metadata2Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-configuration-form", metadata0)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata0Template.resolve(statementContext()), changedValues, metadata0))
            .prepareReset(form -> resetSingletonForm("Container", metadata0Template.resolve(statementContext()), form, metadata0))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-form", metadata1)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata1Template.resolve(statementContext(), name), changedValues, metadata1);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata1Template.resolve(statementContext(), name), form, metadata1);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-form", metadata2)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata2Template.resolve(statementContext(), name), changedValues, metadata2);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Remoting Profile", name, metadata2Template.resolve(statementContext(), name), form, metadata2);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-form", metadata3)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata3Template.resolve(statementContext(), name), changedValues, metadata3);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Bean Pool", name, metadata3Template.resolve(statementContext(), name), form, metadata3);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-form", metadata4)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata4Template.resolve(statementContext(), name), changedValues, metadata4);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Cache", name, metadata4Template.resolve(statementContext(), name), form, metadata4);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-form", metadata5)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata5Template.resolve(statementContext(), name), changedValues, metadata5);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Passivation", name, metadata5Template.resolve(statementContext(), name), form, metadata5);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-async-form", metadata6)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata6Template.resolve(statementContext()), changedValues, metadata6))
            .prepareReset(form -> resetSingletonForm("Async", metadata6Template.resolve(statementContext()), form, metadata6))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIdentityForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-identity-form", metadata7)
            .singleton(
                () -> new Operation.Builder(metadata7Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-identity-form", "Identity", metadata7Template))
            .prepareRemove(form -> removeSingletonForm("Identity", metadata7Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Identity", metadata7Template.resolve(statementContext()), changedValues, metadata7))
            .prepareReset(form -> resetSingletonForm("Identity", metadata7Template.resolve(statementContext()), form, metadata7))
            .build();
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-iiop-form", metadata8)
            .singleton(
                () -> new Operation.Builder(metadata8Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-iiop-form", "IIOP", metadata8Template))
            .prepareRemove(form -> removeSingletonForm("IIOP", metadata8Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata8Template.resolve(statementContext()), changedValues, metadata8))
            .prepareReset(form -> resetSingletonForm("IIOP", metadata8Template.resolve(statementContext()), form, metadata8))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-remote-form", metadata9)
            .include("cluster", "connectors", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata9Template.resolve(statementContext()), changedValues, metadata9))
            .prepareReset(form -> resetSingletonForm("Remote", metadata9Template.resolve(statementContext()), form, metadata9))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
        List<AddressTemplate> serviceRemoteFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*"));
        serviceRemoteForm.getFormItem("connectors").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), serviceRemoteFormTemplates));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-timer-form", metadata10)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata10Template.resolve(statementContext()), changedValues, metadata10))
            .prepareReset(form -> resetSingletonForm("Timer", metadata10Template.resolve(statementContext()), form, metadata10))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-form", metadata11)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata11Template.resolve(statementContext(), name), changedValues, metadata11);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("MDB Delivery Group", name, metadata11Template.resolve(statementContext(), name), form, metadata11);
            })
            .build();

        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-table", metadata1)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata1Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata1Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-table", metadata2)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-remoting-profile-table", Ids.ADD), "Remoting Profile",
                metadata2Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata2Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-table", metadata3)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-bean-pool-table", Ids.ADD), "Bean Pool",
                metadata3Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata3Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-table", metadata4)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-cache-table", Ids.ADD), "Cache",
                metadata4Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata4Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-table", metadata5)
            .button(mbuiContext.tableButtonFactory().add(metadata5Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb3-passivation-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata5,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata5Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata5Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-table", metadata11)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-mdb-delivery-group-table", Ids.ADD), "MDB Delivery Group",
                metadata11Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata11Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb3-container-item", "Container", "fa fa-cogs");
        HTMLElement html0;
        HTMLElement ejb3ConfigurationItemElement = section()
            .add(html0 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>${metadata0.getDescription().getDescription()}</p>"))
                                    .element())
            .add(configurationForm)
                            .element();
        expressionElements.put("html0", html0);
        navigation.addSecondary("ejb3-container-item", "ejb3-configuration-item", "Container", ejb3ConfigurationItemElement);
        HTMLElement html2;
        HTMLElement ejb3ThreadPoolItemElement = section()
            .add(html2 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata1.getDescription().getDescription()}</p>"))
                                    .element())
            .add(threadPoolTable)
            .add(threadPoolForm)
                            .element();
        expressionElements.put("html2", html2);
        navigation.addSecondary("ejb3-container-item", "ejb3-thread-pool-item", "Thread Pool", ejb3ThreadPoolItemElement);
        HTMLElement html5;
        HTMLElement ejb3RemotingProfileItemElement = section()
            .add(html5 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>${metadata2.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remotingProfileTable)
            .add(remotingProfileForm)
                            .element();
        expressionElements.put("html5", html5);
        navigation.addSecondary("ejb3-container-item", "ejb3-remoting-profile-item", "Remoting Profile", ejb3RemotingProfileItemElement);
        HTMLElement html8;
        HTMLElement ejb3BeanPoolItemElement = section()
            .add(html8 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>${metadata3.getDescription().getDescription()}</p>"))
                            .element())
            .add(beanPoolTable)
            .add(beanPoolForm)
                    .element();
        expressionElements.put("html8", html8);
        navigation.addPrimary("ejb3-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejb3BeanPoolItemElement);
        navigation.addPrimary("ejb3-state-item", "State Management", "fa fa-list-ul");
        HTMLElement html11;
        HTMLElement ejb3CacheItemElement = section()
            .add(html11 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>${metadata4.getDescription().getDescription()}</p>"))
                                    .element())
            .add(cacheTable)
            .add(cacheForm)
                            .element();
        expressionElements.put("html11", html11);
        navigation.addSecondary("ejb3-state-item", "ejb3-cache-item", "Cache", ejb3CacheItemElement);
        HTMLElement html14;
        HTMLElement ejb3PassivationItemElement = section()
            .add(html14 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>${metadata5.getDescription().getDescription()}</p>"))
                                    .element())
            .add(passivationTable)
            .add(passivationForm)
                            .element();
        expressionElements.put("html14", html14);
        navigation.addSecondary("ejb3-state-item", "ejb3-passivation-item", "Passivation", ejb3PassivationItemElement);
        navigation.addPrimary("ejb3-service-item", "Services", "pficon pficon-service");
        HTMLElement html17;
        HTMLElement ejb3ServiceAsyncItemElement = section()
            .add(html17 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>${metadata6.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceAsyncForm)
                            .element();
        expressionElements.put("html17", html17);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-async-item", "Async", ejb3ServiceAsyncItemElement);
        HTMLElement html19;
        HTMLElement ejb3ServiceIdentityItemElement = section()
            .add(html19 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Identity</h1><p>${metadata7.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceIdentityForm)
                            .element();
        expressionElements.put("html19", html19);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-identity-item", "Identity", ejb3ServiceIdentityItemElement);
        HTMLElement html21;
        HTMLElement ejb3ServiceIiopItemElement = section()
            .add(html21 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>${metadata8.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceIiopForm)
                            .element();
        expressionElements.put("html21", html21);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-iiop-item", "IIOP", ejb3ServiceIiopItemElement);
        HTMLElement html23;
        HTMLElement ejb3ServiceRemoteItemElement = section()
            .add(html23 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>${metadata9.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceRemoteForm)
                            .element();
        expressionElements.put("html23", html23);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-remote-item", "Remote", ejb3ServiceRemoteItemElement);
        HTMLElement html25;
        HTMLElement ejb3ServiceTimerItemElement = section()
            .add(html25 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>${metadata10.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceTimerForm)
                            .element();
        expressionElements.put("html25", html25);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-timer-item", "Timer", ejb3ServiceTimerItemElement);
        HTMLElement html27;
        HTMLElement ejb3MdbDeliveryGroupItemElement = section()
            .add(html27 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>${metadata11.getDescription().getDescription()}</p>"))
                            .element())
            .add(mdbDeliveryGroupTable)
            .add(mdbDeliveryGroupForm)
                    .element();
        expressionElements.put("html27", html27);
        navigation.addPrimary("ejb3-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejb3MdbDeliveryGroupItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIdentityForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html0"), "${metadata0.getDescription().getDescription()}", String.valueOf(metadata0.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html2"), "${metadata1.getDescription().getDescription()}", String.valueOf(metadata1.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html5"), "${metadata2.getDescription().getDescription()}", String.valueOf(metadata2.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html8"), "${metadata3.getDescription().getDescription()}", String.valueOf(metadata3.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html11"), "${metadata4.getDescription().getDescription()}", String.valueOf(metadata4.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html14"), "${metadata5.getDescription().getDescription()}", String.valueOf(metadata5.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html17"), "${metadata6.getDescription().getDescription()}", String.valueOf(metadata6.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html19"), "${metadata7.getDescription().getDescription()}", String.valueOf(metadata7.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html21"), "${metadata8.getDescription().getDescription()}", String.valueOf(metadata8.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html23"), "${metadata9.getDescription().getDescription()}", String.valueOf(metadata9.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html25"), "${metadata10.getDescription().getDescription()}", String.valueOf(metadata10.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html27"), "${metadata11.getDescription().getDescription()}", String.valueOf(metadata11.getDescription().getDescription()));
    }
}
