package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ConnectionView extends ConnectionView {

    private final Metadata metadata74;
    private final Metadata metadata73;
    private final Metadata metadata71;
    private final Metadata metadata69;
    private final Metadata metadata66;
    private final Metadata metadata72;
    private final Metadata metadata70;
    private final Metadata metadata67;
    private final Metadata metadata68;
    private final Metadata metadata65;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ConnectionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata74Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*");
        this.metadata74 = mbuiContext.metadataRegistry().lookup(metadata74Template);
        AddressTemplate metadata73Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*");
        this.metadata73 = mbuiContext.metadataRegistry().lookup(metadata73Template);
        AddressTemplate metadata71Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*");
        this.metadata71 = mbuiContext.metadataRegistry().lookup(metadata71Template);
        AddressTemplate metadata69Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector=*");
        this.metadata69 = mbuiContext.metadataRegistry().lookup(metadata69Template);
        AddressTemplate metadata66Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*");
        this.metadata66 = mbuiContext.metadataRegistry().lookup(metadata66Template);
        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        AddressTemplate metadata70Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*");
        this.metadata70 = mbuiContext.metadataRegistry().lookup(metadata70Template);
        AddressTemplate metadata67Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*");
        this.metadata67 = mbuiContext.metadataRegistry().lookup(metadata67Template);
        AddressTemplate metadata68Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*");
        this.metadata68 = mbuiContext.metadataRegistry().lookup(metadata68Template);
        AddressTemplate metadata65Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*");
        this.metadata65 = mbuiContext.metadataRegistry().lookup(metadata65Template);
        this.expressionElements = new HashMap<>();

        acceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-form", metadata65)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ACCEPTOR, form))
            .build();
        acceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-form", metadata66)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_ACCEPTOR, form))
            .build();
        httpAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-form", metadata67)
            .include("http-listener", "upgrade-legacy", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_ACCEPTOR, form))
            .build();
        httpAcceptorForm.getFormItem("http-listener").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/http-listener=*")));
        remoteAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-form", metadata68)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_ACCEPTOR, form))
            .build();
        remoteAcceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-form", metadata69)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR, form))
            .build();
        connectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-form", metadata70)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-form", metadata71)
            .include("endpoint", "server-name", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_CONNECTOR, form))
            .build();
        httpConnectorForm.getFormItem("endpoint").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*")));
        httpConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-form", metadata72)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_CONNECTOR, form))
            .build();
        remoteConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorServiceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-form", metadata73)
            .include("factory-class", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR_SERVICE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR_SERVICE, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-form", metadata74)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTION_FACTORY, form))
            .build();

        acceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-table", metadata65)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-table", metadata66)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-table", metadata67)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttp(ServerSubResource.HTTP_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-table", metadata68)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-table", metadata69)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-table", metadata70)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-table", metadata71)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-table", metadata72)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorServiceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-table", metadata73)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR_SERVICE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR_SERVICE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-table", metadata74)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-acceptor-group-item", "Acceptor", "fa fa-sign-in");
        HTMLElement html196;
        HTMLElement messagingAcceptorItemElement = section()
            .add(html196 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Acceptor</h1><p>${metadata65.getDescription().getDescription()}</p>"))
                                    .element())
            .add(acceptorTable)
            .add(acceptorForm)
                            .element();
        expressionElements.put("html196", html196);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-acceptor-item", "Generic", messagingAcceptorItemElement);
        HTMLElement html199;
        HTMLElement messagingInVmAcceptorItemElement = section()
            .add(html199 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Acceptor</h1><p>${metadata66.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmAcceptorTable)
            .add(inVmAcceptorForm)
                            .element();
        expressionElements.put("html199", html199);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-in-vm-acceptor-item", "In VM", messagingInVmAcceptorItemElement);
        HTMLElement html202;
        HTMLElement messagingHttpAcceptorItemElement = section()
            .add(html202 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Acceptor</h1><p>${metadata67.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpAcceptorTable)
            .add(httpAcceptorForm)
                            .element();
        expressionElements.put("html202", html202);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-http-acceptor-item", "HTTP", messagingHttpAcceptorItemElement);
        HTMLElement html205;
        HTMLElement messagingRemoteAcceptorItemElement = section()
            .add(html205 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Acceptor</h1><p>${metadata68.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteAcceptorTable)
            .add(remoteAcceptorForm)
                            .element();
        expressionElements.put("html205", html205);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-remote-acceptor-item", "Remote", messagingRemoteAcceptorItemElement);
        navigation.addPrimary("messaging-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html208;
        HTMLElement messagingConnectorItemElement = section()
            .add(html208 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata69.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
            .add(connectorForm)
                            .element();
        expressionElements.put("html208", html208);
        navigation.addSecondary("messaging-connector-group-item", "messaging-connector-item", "Generic", messagingConnectorItemElement);
        HTMLElement html211;
        HTMLElement messagingInVmConnectorItemElement = section()
            .add(html211 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata70.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
                            .element();
        expressionElements.put("html211", html211);
        navigation.addSecondary("messaging-connector-group-item", "messaging-in-vm-connector-item", "In VM", messagingInVmConnectorItemElement);
        HTMLElement html214;
        HTMLElement messagingHttpConnectorItemElement = section()
            .add(html214 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata71.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
                            .element();
        expressionElements.put("html214", html214);
        navigation.addSecondary("messaging-connector-group-item", "messaging-http-connector-item", "HTTP", messagingHttpConnectorItemElement);
        HTMLElement html217;
        HTMLElement messagingRemoteConnectorItemElement = section()
            .add(html217 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata72.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
                            .element();
        expressionElements.put("html217", html217);
        navigation.addSecondary("messaging-connector-group-item", "messaging-remote-connector-item", "Remote", messagingRemoteConnectorItemElement);
        HTMLElement html220;
        HTMLElement messagingConnectorServiceItemElement = section()
            .add(html220 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector Service</h1><p>${metadata73.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectorServiceTable)
            .add(connectorServiceForm)
                    .element();
        expressionElements.put("html220", html220);
        navigation.addPrimary("messaging-connector-service-item", "Connector Service", "pficon pficon-service", messagingConnectorServiceItemElement);
        HTMLElement html223;
        HTMLElement messagingConnectionFactoryItemElement = section()
            .add(html223 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata74.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
                    .element();
        expressionElements.put("html223", html223);
        navigation.addPrimary("messaging-connection-factory-item", "Connection Factory", "fa fa-cubes", messagingConnectionFactoryItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(acceptorTable);
        registerAttachable(acceptorForm);
        registerAttachable(inVmAcceptorTable);
        registerAttachable(inVmAcceptorForm);
        registerAttachable(httpAcceptorTable);
        registerAttachable(httpAcceptorForm);
        registerAttachable(remoteAcceptorTable);
        registerAttachable(remoteAcceptorForm);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(connectorServiceTable);
        registerAttachable(connectorServiceForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            acceptorTable.bindForm(acceptorForm);
            inVmAcceptorTable.bindForm(inVmAcceptorForm);
            httpAcceptorTable.bindForm(httpAcceptorForm);
            remoteAcceptorTable.bindForm(remoteAcceptorForm);
            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            connectorServiceTable.bindForm(connectorServiceForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html196"), "${metadata65.getDescription().getDescription()}", String.valueOf(metadata65.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html199"), "${metadata66.getDescription().getDescription()}", String.valueOf(metadata66.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html202"), "${metadata67.getDescription().getDescription()}", String.valueOf(metadata67.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html205"), "${metadata68.getDescription().getDescription()}", String.valueOf(metadata68.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html208"), "${metadata69.getDescription().getDescription()}", String.valueOf(metadata69.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html211"), "${metadata70.getDescription().getDescription()}", String.valueOf(metadata70.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html214"), "${metadata71.getDescription().getDescription()}", String.valueOf(metadata71.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html217"), "${metadata72.getDescription().getDescription()}", String.valueOf(metadata72.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html220"), "${metadata73.getDescription().getDescription()}", String.valueOf(metadata73.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html223"), "${metadata74.getDescription().getDescription()}", String.valueOf(metadata74.getDescription().getDescription()));
    }
}
