package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DestinationView extends DestinationView {

    private final Metadata metadata116;
    private final Metadata metadata115;
    private final Metadata metadata114;
    private final Metadata metadata117;
    private final Metadata metadata118;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DestinationView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata116Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*");
        this.metadata116 = mbuiContext.metadataRegistry().lookup(metadata116Template);
        AddressTemplate metadata115Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*");
        this.metadata115 = mbuiContext.metadataRegistry().lookup(metadata115Template);
        AddressTemplate metadata114Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/queue=*");
        this.metadata114 = mbuiContext.metadataRegistry().lookup(metadata114Template);
        AddressTemplate metadata117Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*");
        this.metadata117 = mbuiContext.metadataRegistry().lookup(metadata117Template);
        AddressTemplate metadata118Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/divert=*");
        this.metadata118 = mbuiContext.metadataRegistry().lookup(metadata118Template);
        this.expressionElements = new HashMap<>();

        coreQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-form", metadata114)
            .include("queue-address", "filter", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CORE_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CORE_QUEUE, form))
            .build();
        jmsQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-form", metadata115)
            .include("selector", "entries", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_QUEUE, form))
            .build();
        jmsTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-form", metadata116)
            .include("entries")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_TOPIC, form))
            .build();
        addressSettingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-form", metadata117)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ADDRESS_SETTING, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ADDRESS_SETTING, form))
            .build();
        divertForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-form", metadata118)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DIVERT, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DIVERT, form))
            .build();

        coreQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-table", metadata114)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addCoreQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CORE_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("queue-address")
            .build();
        jmsQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-table", metadata115)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addJMSQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("selector")
            .build();
        jmsTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-table", metadata116)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JMS_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        addressSettingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-table", metadata117)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ADDRESS_SETTING), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ADDRESS_SETTING, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        divertTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-table", metadata118)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DIVERT), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DIVERT, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html343;
        HTMLElement messagingCoreQueueItemElement = section()
            .add(html343 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Core Queue</h1><p>${metadata114.getDescription().getDescription()}</p>"))
                            .element())
            .add(coreQueueTable)
            .add(coreQueueForm)
                    .element();
        expressionElements.put("html343", html343);
        navigation.addPrimary("messaging-core-queue-item", "Core Queue", "fa fa-cog", messagingCoreQueueItemElement);
        HTMLElement html346;
        HTMLElement messagingJmsQueueItemElement = section()
            .add(html346 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Queue</h1><p>${metadata115.getDescription().getDescription()}</p>"))
                            .element())
            .add(jmsQueueTable)
            .add(jmsQueueForm)
                    .element();
        expressionElements.put("html346", html346);
        navigation.addPrimary("messaging-jms-queue-item", "JMS Queue", "fa fa-long-arrow-right", messagingJmsQueueItemElement);
        HTMLElement html349;
        HTMLElement messagingJmsTopicItemElement = section()
            .add(html349 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Topic</h1><p>${metadata116.getDescription().getDescription()}</p>"))
                            .element())
            .add(jmsTopicTable)
            .add(jmsTopicForm)
                    .element();
        expressionElements.put("html349", html349);
        navigation.addPrimary("messaging-jms-topic-item", "JMS Topic", "fa fa-arrows", messagingJmsTopicItemElement);
        HTMLElement html352;
        HTMLElement messagingAddressSettingItemElement = section()
            .add(html352 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Address Setting</h1><p>${metadata117.getDescription().getDescription()}</p>"))
                            .element())
            .add(addressSettingTable)
            .add(addressSettingForm)
                    .element();
        expressionElements.put("html352", html352);
        navigation.addPrimary("messaging-address-setting-item", "Address Setting", "fa fa-address-card-o", messagingAddressSettingItemElement);
        HTMLElement html355;
        HTMLElement messagingDivertItemElement = section()
            .add(html355 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Divert</h1><p>${metadata118.getDescription().getDescription()}</p>"))
                            .element())
            .add(divertTable)
            .add(divertForm)
                    .element();
        expressionElements.put("html355", html355);
        navigation.addPrimary("messaging-divert-item", "Divert", "fa fa-exchange", messagingDivertItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(coreQueueTable);
        registerAttachable(coreQueueForm);
        registerAttachable(jmsQueueTable);
        registerAttachable(jmsQueueForm);
        registerAttachable(jmsTopicTable);
        registerAttachable(jmsTopicForm);
        registerAttachable(addressSettingTable);
        registerAttachable(addressSettingForm);
        registerAttachable(divertTable);
        registerAttachable(divertForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            coreQueueTable.bindForm(coreQueueForm);
            jmsQueueTable.bindForm(jmsQueueForm);
            jmsTopicTable.bindForm(jmsTopicForm);
            addressSettingTable.bindForm(addressSettingForm);
            divertTable.bindForm(divertForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html343"), "${metadata114.getDescription().getDescription()}", String.valueOf(metadata114.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html346"), "${metadata115.getDescription().getDescription()}", String.valueOf(metadata115.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html349"), "${metadata116.getDescription().getDescription()}", String.valueOf(metadata116.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html352"), "${metadata117.getDescription().getDescription()}", String.valueOf(metadata117.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html355"), "${metadata118.getDescription().getDescription()}", String.valueOf(metadata118.getDescription().getDescription()));
    }
}
