package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemoteActiveMQView extends RemoteActiveMQView {

    private final Metadata metadata29;
    private final Metadata metadata27;
    private final Metadata metadata25;
    private final Metadata metadata31;
    private final Metadata metadata26;
    private final Metadata metadata28;
    private final Metadata metadata24;
    private final Metadata metadata30;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemoteActiveMQView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata29Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connection-factory=*");
        this.metadata29 = mbuiContext.metadataRegistry().lookup(metadata29Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/remote-connector=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        AddressTemplate metadata25Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/in-vm-connector=*");
        this.metadata25 = mbuiContext.metadataRegistry().lookup(metadata25Template);
        AddressTemplate metadata31Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-topic=*");
        this.metadata31 = mbuiContext.metadataRegistry().lookup(metadata31Template);
        AddressTemplate metadata26Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/http-connector=*");
        this.metadata26 = mbuiContext.metadataRegistry().lookup(metadata26Template);
        AddressTemplate metadata28Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/discovery-group=*");
        this.metadata28 = mbuiContext.metadataRegistry().lookup(metadata28Template);
        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connector=*");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        AddressTemplate metadata30Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-queue=*");
        this.metadata30 = mbuiContext.metadataRegistry().lookup(metadata30Template);
        this.expressionElements = new HashMap<>();

        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-form", metadata24)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTOR, form))
            .build();
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-form", metadata25)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-form", metadata26)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.HTTP_CONNECTOR, form))
            .build();
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-form", metadata27)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form))
            .build();
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-form", metadata28)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.DISCOVERY_GROUP, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-form", metadata29)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTION_FACTORY, form))
            .build();
        externalQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-form", metadata30)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form))
            .build();
        externalTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-form", metadata31)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form))
            .build();

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-table", metadata24)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-table", metadata25)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-table", metadata26)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-table", metadata27)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemoteConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-table", metadata28)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-table", metadata29)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addConnectionFactory(RemoteActiveMQSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-table", metadata30)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_QUEUE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-table", metadata31)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("msg-remote-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html72;
        HTMLElement msgRemoteConnectorItemElement = section()
            .add(html72 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata24.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
            .add(connectorForm)
                            .element();
        expressionElements.put("html72", html72);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-connector-item", "Generic", msgRemoteConnectorItemElement);
        HTMLElement html75;
        HTMLElement msgRemoteInVmConnectorItemElement = section()
            .add(html75 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata25.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
                            .element();
        expressionElements.put("html75", html75);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-in-vm-connector-item", "In VM", msgRemoteInVmConnectorItemElement);
        HTMLElement html78;
        HTMLElement msgRemoteHttpConnectorItemElement = section()
            .add(html78 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata26.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
                            .element();
        expressionElements.put("html78", html78);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-http-connector-item", "HTTP", msgRemoteHttpConnectorItemElement);
        HTMLElement html81;
        HTMLElement msgRemoteRemoteConnectorItemElement = section()
            .add(html81 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata27.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
                            .element();
        expressionElements.put("html81", html81);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-remote-connector-item", "Remote", msgRemoteRemoteConnectorItemElement);
        HTMLElement html84;
        HTMLElement msgRemoteDiscoveryGroupItemElement = section()
            .add(html84 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>${metadata28.getDescription().getDescription()}</p>"))
                            .element())
            .add(discoveryGroupTable)
            .add(discoveryGroupForm)
                    .element();
        expressionElements.put("html84", html84);
        navigation.addPrimary("msg-remote-discovery-group-item", "Discovery Group", "pficon pficon-service", msgRemoteDiscoveryGroupItemElement);
        HTMLElement html87;
        HTMLElement msgRemoteConnectionFactoryItemElement = section()
            .add(html87 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata29.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
                    .element();
        expressionElements.put("html87", html87);
        navigation.addPrimary("msg-remote-connection-factory-item", "Connection Factory", "fa fa-cubes", msgRemoteConnectionFactoryItemElement);
        HTMLElement html90;
        HTMLElement msgRemoteExternalQueueItemElement = section()
            .add(html90 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Queue</h1><p>${metadata30.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalQueueTable)
            .add(externalQueueForm)
                    .element();
        expressionElements.put("html90", html90);
        navigation.addPrimary("msg-remote-external-queue-item", "External JMS Queue", "fa fa-long-arrow-right", msgRemoteExternalQueueItemElement);
        HTMLElement html93;
        HTMLElement msgRemoteExternalTopicItemElement = section()
            .add(html93 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Topic</h1><p>${metadata31.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalTopicTable)
            .add(externalTopicForm)
                    .element();
        expressionElements.put("html93", html93);
        navigation.addPrimary("msg-remote-external-topic-item", "External JMS Topic", "fa fa-arrows", msgRemoteExternalTopicItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);
        registerAttachable(externalQueueTable);
        registerAttachable(externalQueueForm);
        registerAttachable(externalTopicTable);
        registerAttachable(externalTopicForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);
            externalQueueTable.bindForm(externalQueueForm);
            externalTopicTable.bindForm(externalTopicForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html72"), "${metadata24.getDescription().getDescription()}", String.valueOf(metadata24.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html75"), "${metadata25.getDescription().getDescription()}", String.valueOf(metadata25.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html78"), "${metadata26.getDescription().getDescription()}", String.valueOf(metadata26.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html81"), "${metadata27.getDescription().getDescription()}", String.valueOf(metadata27.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html84"), "${metadata28.getDescription().getDescription()}", String.valueOf(metadata28.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html87"), "${metadata29.getDescription().getDescription()}", String.valueOf(metadata29.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html90"), "${metadata30.getDescription().getDescription()}", String.valueOf(metadata30.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html93"), "${metadata31.getDescription().getDescription()}", String.valueOf(metadata31.getDescription().getDescription()));
    }
}
