package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityDomainView extends SecurityDomainView {

    private final Metadata metadata87;
    private final Metadata metadata82;
    private final Metadata metadata83;
    private final Metadata metadata86;
    private final Metadata metadata84;
    private final Metadata metadata85;
    private final Metadata metadata81;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityDomainView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata87Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*");
        this.metadata87 = mbuiContext.metadataRegistry().lookup(metadata87Template);
        AddressTemplate metadata82Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*");
        this.metadata82 = mbuiContext.metadataRegistry().lookup(metadata82Template);
        AddressTemplate metadata83Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*");
        this.metadata83 = mbuiContext.metadataRegistry().lookup(metadata83Template);
        AddressTemplate metadata86Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*");
        this.metadata86 = mbuiContext.metadataRegistry().lookup(metadata86Template);
        AddressTemplate metadata84Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*");
        this.metadata84 = mbuiContext.metadataRegistry().lookup(metadata84Template);
        AddressTemplate metadata85Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*");
        this.metadata85 = mbuiContext.metadataRegistry().lookup(metadata85Template);
        AddressTemplate metadata81Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*");
        this.metadata81 = mbuiContext.metadataRegistry().lookup(metadata81Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-domain-configuration-form", metadata81)
            .onSave((form, changedValues) -> presenter.saveSecurityDomain(changedValues))
            .prepareReset(form -> presenter.resetSecurityDomain(form))
            .build();
        authenticationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-form", metadata82)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHENTICATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHENTICATION))
            .build();
        authorizationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-form", metadata83)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHORIZATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHORIZATION))
            .build();
        auditForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-form", metadata84)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUDIT))
            .prepareReset(form -> presenter.resetModule(form, Module.AUDIT))
            .build();
        aclForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-form", metadata85)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.ACL))
            .prepareReset(form -> presenter.resetModule(form, Module.ACL))
            .build();
        trustForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-form", metadata87)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.TRUST))
            .prepareReset(form -> presenter.resetModule(form, Module.TRUST))
            .build();
        mappingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-form", metadata86)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.MAPPING))
            .prepareReset(form -> presenter.resetModule(form, Module.MAPPING))
            .build();

        authenticationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-table", metadata82)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClassicAuthenticationModule(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHENTICATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authorizationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-table", metadata83)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUTHORIZATION), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHORIZATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        auditTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-table", metadata84)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUDIT), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUDIT), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        aclTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-table", metadata85)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.ACL), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.ACL), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        trustTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-table", metadata87)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.TRUST), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.TRUST), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mappingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-table", metadata86)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.MAPPING), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.MAPPING), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html245;
        HTMLElement securityDomainConfigurationItemElement = section()
            .add(html245 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata81.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html245", html245);
        navigation.addPrimary("security-domain-configuration-item", "Configuration", "pficon pficon-settings", securityDomainConfigurationItemElement);
        HTMLElement html247;
        HTMLElement securityDomainAuthenticationItemElement = section()
            .add(html247 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authentication Module</h1><p>${metadata82.getDescription().getDescription()}</p>"))
                            .element())
            .add(authenticationTable)
            .add(authenticationForm)
                    .element();
        expressionElements.put("html247", html247);
        navigation.addPrimary("security-domain-authentication-item", "Authentication", "fa fa-sign-in", securityDomainAuthenticationItemElement);
        HTMLElement html250;
        HTMLElement securityDomainAuthorizationItemElement = section()
            .add(html250 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authorization Module</h1><p>${metadata83.getDescription().getDescription()}</p>"))
                            .element())
            .add(authorizationTable)
            .add(authorizationForm)
                    .element();
        expressionElements.put("html250", html250);
        navigation.addPrimary("security-domain-authorization-item", "Authorization", "fa fa-shield", securityDomainAuthorizationItemElement);
        HTMLElement html253;
        HTMLElement securityDomainAuditItemElement = section()
            .add(html253 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Audit Module</h1><p>${metadata84.getDescription().getDescription()}</p>"))
                            .element())
            .add(auditTable)
            .add(auditForm)
                    .element();
        expressionElements.put("html253", html253);
        navigation.addPrimary("security-domain-audit-item", "Audit", "fa fa-file-text-o", securityDomainAuditItemElement);
        HTMLElement html256;
        HTMLElement securityDomainAclItemElement = section()
            .add(html256 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>ACL Module</h1><p>${metadata85.getDescription().getDescription()}</p>"))
                            .element())
            .add(aclTable)
            .add(aclForm)
                    .element();
        expressionElements.put("html256", html256);
        navigation.addPrimary("security-domain-acl-item", "ACL", "fa fa-lock", securityDomainAclItemElement);
        HTMLElement html259;
        HTMLElement securityDomainMappingItemElement = section()
            .add(html259 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mapping Module</h1><p>${metadata86.getDescription().getDescription()}</p>"))
                            .element())
            .add(mappingTable)
            .add(mappingForm)
                    .element();
        expressionElements.put("html259", html259);
        navigation.addPrimary("security-domain-mapping-item", "Mapping", "fa fa-exchange", securityDomainMappingItemElement);
        HTMLElement html262;
        HTMLElement securityDomainTrustItemElement = section()
            .add(html262 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Trust Module</h1><p>${metadata87.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustTable)
            .add(trustForm)
                    .element();
        expressionElements.put("html262", html262);
        navigation.addPrimary("security-domain-trust-item", "Identity Trust", "fa fa-handshake-o", securityDomainTrustItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(authenticationTable);
        registerAttachable(authenticationForm);
        registerAttachable(authorizationTable);
        registerAttachable(authorizationForm);
        registerAttachable(auditTable);
        registerAttachable(auditForm);
        registerAttachable(aclTable);
        registerAttachable(aclForm);
        registerAttachable(trustTable);
        registerAttachable(trustForm);
        registerAttachable(mappingTable);
        registerAttachable(mappingForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            authenticationTable.bindForm(authenticationForm);
            authorizationTable.bindForm(authorizationForm);
            auditTable.bindForm(auditForm);
            aclTable.bindForm(aclForm);
            trustTable.bindForm(trustForm);
            mappingTable.bindForm(mappingForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html245"), "${metadata81.getDescription().getDescription()}", String.valueOf(metadata81.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html247"), "${metadata82.getDescription().getDescription()}", String.valueOf(metadata82.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html250"), "${metadata83.getDescription().getDescription()}", String.valueOf(metadata83.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html253"), "${metadata84.getDescription().getDescription()}", String.valueOf(metadata84.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html256"), "${metadata85.getDescription().getDescription()}", String.valueOf(metadata85.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html259"), "${metadata86.getDescription().getDescription()}", String.valueOf(metadata86.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html262"), "${metadata87.getDescription().getDescription()}", String.valueOf(metadata87.getDescription().getDescription()));
    }
}
