package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata57;
    private final Metadata metadata60;
    private final Metadata metadata58;
    private final Metadata metadata56;
    private final Metadata metadata61;
    private final Metadata metadata59;
    private final Metadata metadata55;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        AddressTemplate metadata56Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata56 = mbuiContext.metadataRegistry().lookup(metadata56Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata55Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata55 = mbuiContext.metadataRegistry().lookup(metadata55Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata55)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata55Template.resolve(statementContext()), changedValues, metadata55))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata55Template.resolve(statementContext()), form, metadata55))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata56)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata56Template.resolve(statementContext(), name), changedValues, metadata56);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata56Template.resolve(statementContext(), name), form, metadata56);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata57)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata57Template.resolve(statementContext(), name), changedValues, metadata57);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata57Template.resolve(statementContext(), name), form, metadata57);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata58)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata58Template.resolve(statementContext(), name), changedValues, metadata58);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata58Template.resolve(statementContext(), name), form, metadata58);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata59)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata59Template.resolve(statementContext(), name), changedValues, metadata59);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata59Template.resolve(statementContext(), name), form, metadata59);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata60)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata60Template.resolve(statementContext(), name), changedValues, metadata60);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata60Template.resolve(statementContext(), name), form, metadata60);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata61)
            .singleton(
                () -> new Operation.Builder(metadata61Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata61Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata61Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata61Template.resolve(statementContext()), changedValues, metadata61))
            .prepareReset(form -> resetSingletonForm("Vault", metadata61Template.resolve(statementContext()), form, metadata61))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata56)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD), "Elytron Key Manager",
                metadata56Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata56Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata57)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD), "Elytron Key Store",
                metadata57Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata57Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata58)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD), "Elytron Realm",
                metadata58Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata58Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata59)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD), "Elytron Trust Manager",
                metadata59Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata59Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata60)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD), "Elytron Trust Store",
                metadata60Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata60Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html167;
        HTMLElement securityConfigurationItemElement = section()
            .add(html167 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata55.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html167", html167);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html169;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html169 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>${metadata56.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyManagerTable)
            .add(keyManagerForm)
                    .element();
        expressionElements.put("html169", html169);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html172;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html172 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>${metadata57.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyStoreTable)
            .add(keyStoreForm)
                    .element();
        expressionElements.put("html172", html172);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html175;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html175 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>${metadata58.getDescription().getDescription()}</p>"))
                            .element())
            .add(realmTable)
            .add(realmForm)
                    .element();
        expressionElements.put("html175", html175);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html178;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html178 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>${metadata59.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustManagerTable)
            .add(trustManagerForm)
                    .element();
        expressionElements.put("html178", html178);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html181;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html181 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustStoreTable)
            .add(trustStoreForm)
                    .element();
        expressionElements.put("html181", html181);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html184;
        HTMLElement securityVaultItemElement = section()
            .add(html184 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>${metadata61.getDescription().getDescription()}</p>"))
                            .element())
            .add(vaultForm)
                    .element();
        expressionElements.put("html184", html184);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html167"), "${metadata55.getDescription().getDescription()}", String.valueOf(metadata55.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html169"), "${metadata56.getDescription().getDescription()}", String.valueOf(metadata56.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html172"), "${metadata57.getDescription().getDescription()}", String.valueOf(metadata57.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html175"), "${metadata58.getDescription().getDescription()}", String.valueOf(metadata58.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html178"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html181"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html184"), "${metadata61.getDescription().getDescription()}", String.valueOf(metadata61.getDescription().getDescription()));
    }
}
