package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HostView extends HostView {

    private final Metadata metadata119;
    private final Metadata metadata123;
    private final Metadata metadata121;
    private final Metadata metadata122;
    private final Metadata metadata120;
    private final Metadata metadata124;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata119Template = AddressTemplate.of("/{selected.host}");
        this.metadata119 = mbuiContext.metadataRegistry().lookup(metadata119Template);
        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata120Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata120 = mbuiContext.metadataRegistry().lookup(metadata120Template);
        AddressTemplate metadata124Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata124 = mbuiContext.metadataRegistry().lookup(metadata124Template);
        this.expressionElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata119)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata119Template.resolve(statementContext()), form, metadata119))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata120)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata120Template.resolve(statementContext(), name), changedValues, metadata120);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata120Template.resolve(statementContext(), name), form, metadata120);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata121)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata121Template.resolve(statementContext(), name), changedValues, metadata121);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata121Template.resolve(statementContext(), name), form, metadata121);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata122)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata122Template.resolve(statementContext(), name), changedValues, metadata122);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata122Template.resolve(statementContext(), name), form, metadata122);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata123)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata123Template.resolve(statementContext(), name), changedValues, metadata123);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata123Template.resolve(statementContext(), name), form, metadata123);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata124)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata124Template.resolve(statementContext(), name), changedValues, metadata124);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata124Template.resolve(statementContext(), name), form, metadata124);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata120)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD), "Interface",
                metadata120Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata120Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata121)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD), "JVM",
                metadata121Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata121Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata122)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD), "Path",
                metadata122Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata122Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata123)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD), "Socket Binding Group",
                metadata123Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata123Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata124)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD), "System Property",
                metadata124Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata124Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html359;
        HTMLElement hostConfigurationItemElement = section()
            .add(html359 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>${metadata119.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostConfigurationForm)
                    .element();
        expressionElements.put("html359", html359);
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        HTMLElement html361;
        HTMLElement hostInterfaceItemElement = section()
            .add(html361 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata120.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostInterfaceTable)
            .add(hostInterfaceForm)
                    .element();
        expressionElements.put("html361", html361);
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        HTMLElement html364;
        HTMLElement hostJvmItemElement = section()
            .add(html364 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata121.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostJvmTable)
            .add(hostJvmForm)
                    .element();
        expressionElements.put("html364", html364);
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        HTMLElement html367;
        HTMLElement hostPathItemElement = section()
            .add(html367 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata122.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostPathTable)
            .add(hostPathForm)
                    .element();
        expressionElements.put("html367", html367);
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        HTMLElement html370;
        HTMLElement hostSocketBindingGroupItemElement = section()
            .add(html370 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>${metadata123.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSocketBindingGroupTable)
            .add(hostSocketBindingGroupForm)
                    .element();
        expressionElements.put("html370", html370);
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        HTMLElement html373;
        HTMLElement hostSystemPropertyItemElement = section()
            .add(html373 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata124.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSystemPropertyTable)
            .add(hostSystemPropertyForm)
                    .element();
        expressionElements.put("html373", html373);
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html359"), "${metadata119.getDescription().getDescription()}", String.valueOf(metadata119.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html361"), "${metadata120.getDescription().getDescription()}", String.valueOf(metadata120.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html364"), "${metadata121.getDescription().getDescription()}", String.valueOf(metadata121.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html367"), "${metadata122.getDescription().getDescription()}", String.valueOf(metadata122.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html370"), "${metadata123.getDescription().getDescription()}", String.valueOf(metadata123.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html373"), "${metadata124.getDescription().getDescription()}", String.valueOf(metadata124.getDescription().getDescription()));
    }
}
