package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata156;
    private final Metadata metadata157;
    private final Metadata metadata155;
    private final Metadata metadata159;
    private final Metadata metadata158;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata156Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata156 = mbuiContext.metadataRegistry().lookup(metadata156Template);
        AddressTemplate metadata157Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata157 = mbuiContext.metadataRegistry().lookup(metadata157Template);
        AddressTemplate metadata155Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata155 = mbuiContext.metadataRegistry().lookup(metadata155Template);
        AddressTemplate metadata159Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata159 = mbuiContext.metadataRegistry().lookup(metadata159Template);
        AddressTemplate metadata158Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata158 = mbuiContext.metadataRegistry().lookup(metadata158Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata155)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata155Template.resolve(statementContext()), changedValues, metadata155))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata155Template.resolve(statementContext()), form, metadata155))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata156)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata156Template.resolve(statementContext(), name), changedValues, metadata156);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata156Template.resolve(statementContext(), name), form, metadata156);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata157)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata157Template.resolve(statementContext(), name), changedValues, metadata157);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata157Template.resolve(statementContext(), name), form, metadata157);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata158)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata158Template.resolve(statementContext(), name), changedValues, metadata158);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata158Template.resolve(statementContext(), name), form, metadata158);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata159)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata159Template.resolve(statementContext(), name), changedValues, metadata159);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata159Template.resolve(statementContext(), name), form, metadata159);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata156)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata156Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata156Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata157)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "JVM",
                metadata157Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata157Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata158)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata158Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata158Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata159)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata159Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata159Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html465;
        HTMLElement serverConfigurationItemElement = section()
            .add(html465 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata155.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverConfigurationForm)
                    .element();
        expressionElements.put("html465", html465);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html467;
        HTMLElement serverInterfaceItemElement = section()
            .add(html467 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata156.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
                    .element();
        expressionElements.put("html467", html467);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html470;
        HTMLElement serverJvmItemElement = section()
            .add(html470 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata157.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverJvmTable)
            .add(serverJvmForm)
                    .element();
        expressionElements.put("html470", html470);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html473;
        HTMLElement serverPathItemElement = section()
            .add(html473 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata158.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverPathTable)
            .add(serverPathForm)
                    .element();
        expressionElements.put("html473", html473);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html476;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html476 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata159.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
                    .element();
        expressionElements.put("html476", html476);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html465"), "${metadata155.getDescription().getDescription()}", String.valueOf(metadata155.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html467"), "${metadata156.getDescription().getDescription()}", String.valueOf(metadata156.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html470"), "${metadata157.getDescription().getDescription()}", String.valueOf(metadata157.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html473"), "${metadata158.getDescription().getDescription()}", String.valueOf(metadata158.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html476"), "${metadata159.getDescription().getDescription()}", String.valueOf(metadata159.getDescription().getDescription()));
    }
}
