package org.jboss.hal.core.configuration;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ProfileSelectionEvent extends GwtEvent<ProfileSelectionEvent.ProfileSelectionHandler> { 

  java.lang.String profile;

  protected ProfileSelectionEvent() {
    // Possibly for serialization.
  }

  public ProfileSelectionEvent(java.lang.String profile) {
    this.profile = profile;
  }

  public static void fire(HasHandlers source, java.lang.String profile) {
    ProfileSelectionEvent eventInstance = new ProfileSelectionEvent(profile);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ProfileSelectionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasProfileSelectionHandlers extends HasHandlers {
    HandlerRegistration addProfileSelectionHandler(ProfileSelectionHandler handler);
  }

  public interface ProfileSelectionHandler extends EventHandler {
    public void onProfileSelection(ProfileSelectionEvent event);
  }

  private static final Type<ProfileSelectionHandler> TYPE = new Type<ProfileSelectionHandler>();

  public static Type<ProfileSelectionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ProfileSelectionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ProfileSelectionHandler handler) {
    handler.onProfileSelection(this);
  }

  public java.lang.String getProfile(){
    return profile;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ProfileSelectionEvent other = (ProfileSelectionEvent) obj;
    if (profile == null) {
      if (other.profile != null)
        return false;
    } else if (!profile.equals(other.profile))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (profile == null ? 1 : profile.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ProfileSelectionEvent["
                 + profile
    + "]";
  }
}
