package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DestinationView extends DestinationView {

    private final Metadata metadata95;
    private final Metadata metadata94;
    private final Metadata metadata93;
    private final Metadata metadata96;
    private final Metadata metadata97;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DestinationView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata95Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*");
        this.metadata95 = mbuiContext.metadataRegistry().lookup(metadata95Template);
        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/queue=*");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata96Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*");
        this.metadata96 = mbuiContext.metadataRegistry().lookup(metadata96Template);
        AddressTemplate metadata97Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/divert=*");
        this.metadata97 = mbuiContext.metadataRegistry().lookup(metadata97Template);
        this.expressionElements = new HashMap<>();

        coreQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-form", metadata93)
            .include("queue-address", "filter", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CORE_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CORE_QUEUE, form))
            .build();
        jmsQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-form", metadata94)
            .include("selector", "entries", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_QUEUE, form))
            .build();
        jmsTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-form", metadata95)
            .include("entries")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_TOPIC, form))
            .build();
        addressSettingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-form", metadata96)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ADDRESS_SETTING, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ADDRESS_SETTING, form))
            .build();
        divertForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-form", metadata97)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DIVERT, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DIVERT, form))
            .build();

        coreQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-table", metadata93)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addCoreQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CORE_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("queue-address")
            .build();
        jmsQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-table", metadata94)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addJMSQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("selector")
            .build();
        jmsTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-table", metadata95)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JMS_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        addressSettingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-table", metadata96)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ADDRESS_SETTING), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ADDRESS_SETTING, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        divertTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-table", metadata97)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DIVERT), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DIVERT, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html276;
        HTMLElement messagingCoreQueueItemElement = section()
            .add(html276 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Core Queue</h1><p>${metadata93.getDescription().getDescription()}</p>"))
                            .element())
            .add(coreQueueTable)
            .add(coreQueueForm)
                    .element();
        expressionElements.put("html276", html276);
        navigation.addPrimary("messaging-core-queue-item", "Core Queue", "fa fa-cog", messagingCoreQueueItemElement);
        HTMLElement html279;
        HTMLElement messagingJmsQueueItemElement = section()
            .add(html279 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Queue</h1><p>${metadata94.getDescription().getDescription()}</p>"))
                            .element())
            .add(jmsQueueTable)
            .add(jmsQueueForm)
                    .element();
        expressionElements.put("html279", html279);
        navigation.addPrimary("messaging-jms-queue-item", "JMS Queue", "fa fa-long-arrow-right", messagingJmsQueueItemElement);
        HTMLElement html282;
        HTMLElement messagingJmsTopicItemElement = section()
            .add(html282 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Topic</h1><p>${metadata95.getDescription().getDescription()}</p>"))
                            .element())
            .add(jmsTopicTable)
            .add(jmsTopicForm)
                    .element();
        expressionElements.put("html282", html282);
        navigation.addPrimary("messaging-jms-topic-item", "JMS Topic", "fa fa-arrows", messagingJmsTopicItemElement);
        HTMLElement html285;
        HTMLElement messagingAddressSettingItemElement = section()
            .add(html285 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Address Setting</h1><p>${metadata96.getDescription().getDescription()}</p>"))
                            .element())
            .add(addressSettingTable)
            .add(addressSettingForm)
                    .element();
        expressionElements.put("html285", html285);
        navigation.addPrimary("messaging-address-setting-item", "Address Setting", "fa fa-address-card-o", messagingAddressSettingItemElement);
        HTMLElement html288;
        HTMLElement messagingDivertItemElement = section()
            .add(html288 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Divert</h1><p>${metadata97.getDescription().getDescription()}</p>"))
                            .element())
            .add(divertTable)
            .add(divertForm)
                    .element();
        expressionElements.put("html288", html288);
        navigation.addPrimary("messaging-divert-item", "Divert", "fa fa-exchange", messagingDivertItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(coreQueueTable);
        registerAttachable(coreQueueForm);
        registerAttachable(jmsQueueTable);
        registerAttachable(jmsQueueForm);
        registerAttachable(jmsTopicTable);
        registerAttachable(jmsTopicForm);
        registerAttachable(addressSettingTable);
        registerAttachable(addressSettingForm);
        registerAttachable(divertTable);
        registerAttachable(divertForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            coreQueueTable.bindForm(coreQueueForm);
            jmsQueueTable.bindForm(jmsQueueForm);
            jmsTopicTable.bindForm(jmsTopicForm);
            addressSettingTable.bindForm(addressSettingForm);
            divertTable.bindForm(divertForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html276"), "${metadata93.getDescription().getDescription()}", String.valueOf(metadata93.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html279"), "${metadata94.getDescription().getDescription()}", String.valueOf(metadata94.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html282"), "${metadata95.getDescription().getDescription()}", String.valueOf(metadata95.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html285"), "${metadata96.getDescription().getDescription()}", String.valueOf(metadata96.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html288"), "${metadata97.getDescription().getDescription()}", String.valueOf(metadata97.getDescription().getDescription()));
    }
}
