package org.jboss.hal.client.configuration.subsystem.distributableweb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DistributableWebView extends DistributableWebView {

    private final Metadata metadata108;
    private final Metadata metadata109;
    private final Metadata metadata110;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DistributableWebView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata108Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web");
        this.metadata108 = mbuiContext.metadataRegistry().lookup(metadata108Template);
        AddressTemplate metadata109Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/hotrod-single-sign-on-management=*");
        this.metadata109 = mbuiContext.metadataRegistry().lookup(metadata109Template);
        AddressTemplate metadata110Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/infinispan-single-sign-on-management=*");
        this.metadata110 = mbuiContext.metadataRegistry().lookup(metadata110Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("dw-configuration-form", metadata108)
            .onSave((form, changedValues) -> saveSingletonForm("Distributable Web", metadata108Template.resolve(statementContext()), changedValues, metadata108))
            .prepareReset(form -> resetSingletonForm("Distributable Web", metadata108Template.resolve(statementContext()), form, metadata108))
            .build();
        hotRodSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-form", metadata109)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Hotrod Single Sign On Management", name, metadata109Template.resolve(statementContext(), name), changedValues, metadata109);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Hotrod Single Sign On Management", name, metadata109Template.resolve(statementContext(), name), form, metadata109);
            })
            .build();
        infinispanSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-form", metadata110)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Infinispan Single Sign On Management", name, metadata110Template.resolve(statementContext(), name), changedValues, metadata110);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Infinispan Single Sign On Management", name, metadata110Template.resolve(statementContext(), name), form, metadata110);
            })
            .build();

        hotRodSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-table", metadata109)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-hotrod-sso-management-table", Ids.ADD), "Hotrod Single Sign On Management",
                metadata109Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Hotrod Single Sign On Management", metadata109Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        infinispanSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-table", metadata110)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-infinispan-sso-management-table", Ids.ADD), "Infinispan Single Sign On Management",
                metadata110Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Infinispan Single Sign On Management", metadata110Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html323;
        HTMLElement dwConfigurationItemElement = section()
            .add(html323 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Distributable Web</h1><p>${metadata108.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html323", html323);
        navigation.addPrimary("dw-configuration-item", "Configuration", "pficon pficon-settings", dwConfigurationItemElement);
        HTMLElement html325;
        HTMLElement dwHotrodSsoManagementItemElement = section()
            .add(html325 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HotRod SSO Management</h1><p>${metadata109.getDescription().getDescription()}</p>"))
                            .element())
            .add(hotRodSSOManagementTable)
            .add(hotRodSSOManagementForm)
                    .element();
        expressionElements.put("html325", html325);
        navigation.addPrimary("dw-hotrod-sso-management-item", "HotRod SSO", "fa fa-lock", dwHotrodSsoManagementItemElement);
        HTMLElement html328;
        HTMLElement dwInfinispanSsoManagementItemElement = section()
            .add(html328 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Infinispan SSO Management</h1><p>${metadata110.getDescription().getDescription()}</p>"))
                            .element())
            .add(infinispanSSOManagementTable)
            .add(infinispanSSOManagementForm)
                    .element();
        expressionElements.put("html328", html328);
        navigation.addPrimary("dw-infinispan-sso-management-item", "Infinispan SSO", "fa fa-lock", dwInfinispanSsoManagementItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(hotRodSSOManagementTable);
        registerAttachable(hotRodSSOManagementForm);
        registerAttachable(infinispanSSOManagementTable);
        registerAttachable(infinispanSSOManagementForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hotRodSSOManagementTable.bindForm(hotRodSSOManagementForm);
            infinispanSSOManagementTable.bindForm(infinispanSSOManagementForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html323"), "${metadata108.getDescription().getDescription()}", String.valueOf(metadata108.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html325"), "${metadata109.getDescription().getDescription()}", String.valueOf(metadata109.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html328"), "${metadata110.getDescription().getDescription()}", String.valueOf(metadata110.getDescription().getDescription()));
    }
}
