package org.jboss.hal.client.configuration.subsystem.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_IOView extends IOView {

    private final Metadata metadata160;
    private final Metadata metadata161;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_IOView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata160Template = AddressTemplate.of("/{selected.profile}/subsystem=io/worker=*");
        this.metadata160 = mbuiContext.metadataRegistry().lookup(metadata160Template);
        AddressTemplate metadata161Template = AddressTemplate.of("/{selected.profile}/subsystem=io/buffer-pool=*");
        this.metadata161 = mbuiContext.metadataRegistry().lookup(metadata161Template);
        this.expressionElements = new HashMap<>();

        bufferPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-form", metadata161)
            .include("buffer-size", "buffers-per-slice", "direct-buffers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Buffer Pool", name, metadata161Template.resolve(statementContext(), name), changedValues, metadata161);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Buffer Pool", name, metadata161Template.resolve(statementContext(), name), form, metadata161);
            })
            .build();
        workerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-form", metadata160)
            .include("io-threads", "stack-size", "task-keepalive", "task-max-threads")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Worker", name, metadata160Template.resolve(statementContext(), name), changedValues, metadata160);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Worker", name, metadata160Template.resolve(statementContext(), name), form, metadata160);
            })
            .build();

        bufferPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-table", metadata161)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-buffer-pool-table", Ids.ADD), "Buffer Pool",
                metadata161Template, asList("buffer-size", "buffers-per-slice", "direct-buffers"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Pool", metadata161Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        workerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-table", metadata160)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-worker-table", Ids.ADD), "Worker",
                metadata160Template, asList("io-threads", "stack-size", "task-keepalive", "task-max-threads"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Worker", metadata160Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html477;
        HTMLElement ioWorkerItemElement = section()
            .add(html477 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Worker</h1><p>${metadata160.getDescription().getDescription()}</p>"))
                            .element())
            .add(workerTable)
            .add(workerForm)
                    .element();
        expressionElements.put("html477", html477);
        navigation.addPrimary("io-worker-item", "Worker", "fa fa-cogs", ioWorkerItemElement);
        HTMLElement html480;
        HTMLElement ioBufferPoolItemElement = section()
            .add(html480 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Pool</h1><p>${metadata161.getDescription().getDescription()}</p>"))
                            .element())
            .add(bufferPoolTable)
            .add(bufferPoolForm)
                    .element();
        expressionElements.put("html480", html480);
        navigation.addPrimary("io-buffer-pool-item", "Buffer Pool", "pficon pficon-repository", ioBufferPoolItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(bufferPoolTable);
        registerAttachable(bufferPoolForm);
        registerAttachable(workerTable);
        registerAttachable(workerForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            bufferPoolTable.bindForm(bufferPoolForm);
            workerTable.bindForm(workerForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html477"), "${metadata160.getDescription().getDescription()}", String.valueOf(metadata160.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html480"), "${metadata161.getDescription().getDescription()}", String.valueOf(metadata161.getDescription().getDescription()));
    }
}
