package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HandlerView extends HandlerView {

    private final Metadata metadata163;
    private final Metadata metadata162;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HandlerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata163Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=handler/reverse-proxy=*");
        this.metadata163 = mbuiContext.metadataRegistry().lookup(metadata163Template);
        AddressTemplate metadata162Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=handler/file=*");
        this.metadata162 = mbuiContext.metadataRegistry().lookup(metadata162Template);
        this.expressionElements = new HashMap<>();

        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-file-handler-form", metadata162)
            .include("cache-buffer-size")
            .include("cache-buffers")
            .include("case-sensitive")
            .include("directory-listing")
            .include("follow-symlink")
            .include("path")
            .include("safe-symlink-paths")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisHandler()), 7)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata162Template.resolve(statementContext(), name), changedValues, metadata162);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata162Template.resolve(statementContext(), name), form, metadata162);
            })
            .build();
        reverseProxyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-reverse-proxy-form", metadata163)
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("max-request-time")
            .include("max-retries")
            .include("problem-server-retry")
            .include("request-queue-size")
            .include("session-cookie-names")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisHandler()), 8)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Reverse Proxy", name, metadata163Template.resolve(statementContext(), name), changedValues, metadata163);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Reverse Proxy", name, metadata163Template.resolve(statementContext(), name), form, metadata163);
            })
            .build();

        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-file-handler-table", metadata162)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-file-handler-table", Ids.ADD), "File Handler",
                metadata162Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata162Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("path")
            .build();
        reverseProxyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-reverse-proxy-table", metadata163)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-reverse-proxy-table", Ids.ADD), "Reverse Proxy",
                metadata163Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Reverse Proxy", metadata163Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html484;
        HTMLElement undertowFileHandlerItemElement = section()
            .add(html484 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata162.getDescription().getDescription()}</p>"))
                            .element())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
                    .element();
        expressionElements.put("html484", html484);
        navigation.addPrimary("undertow-file-handler-item", "File Handler", "fa fa-file-text-o", undertowFileHandlerItemElement);
        HTMLElement html487;
        HTMLElement undertowReverseProxyItemElement = section()
            .add(html487 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Reverse Proxy</h1><p>${metadata163.getDescription().getDescription()}</p>"))
                            .element())
            .add(reverseProxyTable)
            .add(reverseProxyForm)
                    .element();
        expressionElements.put("html487", html487);
        navigation.addPrimary("undertow-reverse-proxy-item", "Reverse Proxy", "fa fa-undo", undertowReverseProxyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(reverseProxyTable);
        registerAttachable(reverseProxyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            fileHandlerTable.bindForm(fileHandlerForm);
            reverseProxyTable.bindForm(reverseProxyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html484"), "${metadata162.getDescription().getDescription()}", String.valueOf(metadata162.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html487"), "${metadata163.getDescription().getDescription()}", String.valueOf(metadata163.getDescription().getDescription()));
    }
}
