package org.jboss.hal.client.configuration.subsystem.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_BatchView extends BatchView {

    private final Metadata metadata95;
    private final Metadata metadata94;
    private final Metadata metadata91;
    private final Metadata metadata93;
    private final Metadata metadata92;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_BatchView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata95Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-pool=*");
        this.metadata95 = mbuiContext.metadataRegistry().lookup(metadata95Template);
        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        AddressTemplate metadata91Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet");
        this.metadata91 = mbuiContext.metadataRegistry().lookup(metadata91Template);
        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/jdbc-job-repository=*");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata92Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/in-memory-job-repository=*");
        this.metadata92 = mbuiContext.metadataRegistry().lookup(metadata92Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("batch-configuration-form", metadata91)
            .onSave((form, changedValues) -> saveSingletonForm("Subsystem", metadata91Template.resolve(statementContext()), changedValues, metadata91))
            .prepareReset(form -> resetSingletonForm("Subsystem", metadata91Template.resolve(statementContext()), form, metadata91))
            .build();
        jdbcJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-form", metadata93)
            .include("data-source")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JDBC Job Repository", name, metadata93Template.resolve(statementContext(), name), changedValues, metadata93);
            })
            .build();
        jdbcJobRepoForm.getFormItem("data-source").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*")));
        threadFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-form", metadata94)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Factory", name, metadata94Template.resolve(statementContext(), name), changedValues, metadata94);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Factory", name, metadata94Template.resolve(statementContext(), name), form, metadata94);
            })
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-form", metadata95)
            .include("name", "max-threads", "thread-factory")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata95Template.resolve(statementContext(), name), changedValues, metadata95);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata95Template.resolve(statementContext(), name), form, metadata95);
            })
            .build();
        threadPoolForm.getFormItem("thread-factory").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*")));

        inMemoryJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-in-memory-job-repo-table", metadata92)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-in-memory-job-repo-table", Ids.ADD), "In Memory Job",
                metadata92Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("In Memory Job", metadata92Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jdbcJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-table", metadata93)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-jdbc-job-repo-table", Ids.ADD), "JDBC Job Repository",
                metadata93Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JDBC Job Repository", metadata93Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-table", metadata94)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-factory-table", Ids.ADD), "Thread Factory",
                metadata94Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Factory", metadata94Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-table", metadata95)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata95Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata95Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html270;
        HTMLElement batchConfigurationItemElement = section()
            .add(html270 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata91.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html270", html270);
        navigation.addPrimary("batch-configuration-item", "Configuration", "pficon pficon-settings", batchConfigurationItemElement);
        HTMLElement html272;
        HTMLElement batchInMemoryJobRepoItemElement = section()
            .add(html272 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In Memory Job Repository</h1><p>${metadata92.getDescription().getDescription()}</p>"))
                            .element())
            .add(inMemoryJobRepoTable)
                    .element();
        expressionElements.put("html272", html272);
        navigation.addPrimary("batch-in-memory-job-repo-item", "In Memory", "pficon pficon-memory", batchInMemoryJobRepoItemElement);
        HTMLElement html274;
        HTMLElement batchJdbcJobRepoItemElement = section()
            .add(html274 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC Job Repository</h1><p>${metadata93.getDescription().getDescription()}</p>"))
                            .element())
            .add(jdbcJobRepoTable)
            .add(jdbcJobRepoForm)
                    .element();
        expressionElements.put("html274", html274);
        navigation.addPrimary("batch-jdbc-job-repo-item", "JDBC", "fa fa-database", batchJdbcJobRepoItemElement);
        HTMLElement html277;
        HTMLElement batchThreadFactoryItemElement = section()
            .add(html277 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Factory</h1><p>${metadata94.getDescription().getDescription()}</p>"))
                            .element())
            .add(threadFactoryTable)
            .add(threadFactoryForm)
                    .element();
        expressionElements.put("html277", html277);
        navigation.addPrimary("batch-thread-factory-item", "Thread Factory", "pficon pficon-service", batchThreadFactoryItemElement);
        HTMLElement html280;
        HTMLElement batchThreadPoolItemElement = section()
            .add(html280 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata95.getDescription().getDescription()}</p>"))
                            .element())
            .add(threadPoolTable)
            .add(threadPoolForm)
                    .element();
        expressionElements.put("html280", html280);
        navigation.addPrimary("batch-thread-pool-item", "Thread Pool", "pficon pficon-resource-pool", batchThreadPoolItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(inMemoryJobRepoTable);
        registerAttachable(jdbcJobRepoTable);
        registerAttachable(jdbcJobRepoForm);
        registerAttachable(threadFactoryTable);
        registerAttachable(threadFactoryForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            jdbcJobRepoTable.bindForm(jdbcJobRepoForm);
            threadFactoryTable.bindForm(threadFactoryForm);
            threadPoolTable.bindForm(threadPoolForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html270"), "${metadata91.getDescription().getDescription()}", String.valueOf(metadata91.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html272"), "${metadata92.getDescription().getDescription()}", String.valueOf(metadata92.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html274"), "${metadata93.getDescription().getDescription()}", String.valueOf(metadata93.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html277"), "${metadata94.getDescription().getDescription()}", String.valueOf(metadata94.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html280"), "${metadata95.getDescription().getDescription()}", String.valueOf(metadata95.getDescription().getDescription()));
    }
}
