package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemoteActiveMQView extends RemoteActiveMQView {

    private final Metadata metadata77;
    private final Metadata metadata75;
    private final Metadata metadata73;
    private final Metadata metadata79;
    private final Metadata metadata74;
    private final Metadata metadata76;
    private final Metadata metadata72;
    private final Metadata metadata78;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemoteActiveMQView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata77Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connection-factory=*");
        this.metadata77 = mbuiContext.metadataRegistry().lookup(metadata77Template);
        AddressTemplate metadata75Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/remote-connector=*");
        this.metadata75 = mbuiContext.metadataRegistry().lookup(metadata75Template);
        AddressTemplate metadata73Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/in-vm-connector=*");
        this.metadata73 = mbuiContext.metadataRegistry().lookup(metadata73Template);
        AddressTemplate metadata79Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-topic=*");
        this.metadata79 = mbuiContext.metadataRegistry().lookup(metadata79Template);
        AddressTemplate metadata74Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/http-connector=*");
        this.metadata74 = mbuiContext.metadataRegistry().lookup(metadata74Template);
        AddressTemplate metadata76Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/discovery-group=*");
        this.metadata76 = mbuiContext.metadataRegistry().lookup(metadata76Template);
        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connector=*");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        AddressTemplate metadata78Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-queue=*");
        this.metadata78 = mbuiContext.metadataRegistry().lookup(metadata78Template);
        this.expressionElements = new HashMap<>();

        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-form", metadata72)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTOR, form))
            .build();
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-form", metadata73)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-form", metadata74)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.HTTP_CONNECTOR, form))
            .build();
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-form", metadata75)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form))
            .build();
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-form", metadata76)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.DISCOVERY_GROUP, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-form", metadata77)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTION_FACTORY, form))
            .build();
        externalQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-form", metadata78)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form))
            .build();
        externalTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-form", metadata79)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form))
            .build();

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-table", metadata72)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-table", metadata73)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-table", metadata74)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-table", metadata75)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemoteConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-table", metadata76)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-table", metadata77)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addConnectionFactory(RemoteActiveMQSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-table", metadata78)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_QUEUE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-table", metadata79)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("msg-remote-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html212;
        HTMLElement msgRemoteConnectorItemElement = section()
            .add(html212 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata72.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
            .add(connectorForm)
                            .element();
        expressionElements.put("html212", html212);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-connector-item", "Generic", msgRemoteConnectorItemElement);
        HTMLElement html215;
        HTMLElement msgRemoteInVmConnectorItemElement = section()
            .add(html215 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata73.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
                            .element();
        expressionElements.put("html215", html215);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-in-vm-connector-item", "In VM", msgRemoteInVmConnectorItemElement);
        HTMLElement html218;
        HTMLElement msgRemoteHttpConnectorItemElement = section()
            .add(html218 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata74.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
                            .element();
        expressionElements.put("html218", html218);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-http-connector-item", "HTTP", msgRemoteHttpConnectorItemElement);
        HTMLElement html221;
        HTMLElement msgRemoteRemoteConnectorItemElement = section()
            .add(html221 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata75.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
                            .element();
        expressionElements.put("html221", html221);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-remote-connector-item", "Remote", msgRemoteRemoteConnectorItemElement);
        HTMLElement html224;
        HTMLElement msgRemoteDiscoveryGroupItemElement = section()
            .add(html224 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>${metadata76.getDescription().getDescription()}</p>"))
                            .element())
            .add(discoveryGroupTable)
            .add(discoveryGroupForm)
                    .element();
        expressionElements.put("html224", html224);
        navigation.addPrimary("msg-remote-discovery-group-item", "Discovery Group", "pficon pficon-service", msgRemoteDiscoveryGroupItemElement);
        HTMLElement html227;
        HTMLElement msgRemoteConnectionFactoryItemElement = section()
            .add(html227 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata77.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
                    .element();
        expressionElements.put("html227", html227);
        navigation.addPrimary("msg-remote-connection-factory-item", "Connection Factory", "fa fa-cubes", msgRemoteConnectionFactoryItemElement);
        HTMLElement html230;
        HTMLElement msgRemoteExternalQueueItemElement = section()
            .add(html230 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Queue</h1><p>${metadata78.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalQueueTable)
            .add(externalQueueForm)
                    .element();
        expressionElements.put("html230", html230);
        navigation.addPrimary("msg-remote-external-queue-item", "External JMS Queue", "fa fa-long-arrow-right", msgRemoteExternalQueueItemElement);
        HTMLElement html233;
        HTMLElement msgRemoteExternalTopicItemElement = section()
            .add(html233 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Topic</h1><p>${metadata79.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalTopicTable)
            .add(externalTopicForm)
                    .element();
        expressionElements.put("html233", html233);
        navigation.addPrimary("msg-remote-external-topic-item", "External JMS Topic", "fa fa-arrows", msgRemoteExternalTopicItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);
        registerAttachable(externalQueueTable);
        registerAttachable(externalQueueForm);
        registerAttachable(externalTopicTable);
        registerAttachable(externalTopicForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);
            externalQueueTable.bindForm(externalQueueForm);
            externalTopicTable.bindForm(externalTopicForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html212"), "${metadata72.getDescription().getDescription()}", String.valueOf(metadata72.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html215"), "${metadata73.getDescription().getDescription()}", String.valueOf(metadata73.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html218"), "${metadata74.getDescription().getDescription()}", String.valueOf(metadata74.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html221"), "${metadata75.getDescription().getDescription()}", String.valueOf(metadata75.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html224"), "${metadata76.getDescription().getDescription()}", String.valueOf(metadata76.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html227"), "${metadata77.getDescription().getDescription()}", String.valueOf(metadata77.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html230"), "${metadata78.getDescription().getDescription()}", String.valueOf(metadata78.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html233"), "${metadata79.getDescription().getDescription()}", String.valueOf(metadata79.getDescription().getDescription()));
    }
}
