package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SocketBindingGroupView extends SocketBindingGroupView {

    private final Metadata metadata54;
    private final Metadata metadata53;
    private final Metadata metadata52;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SocketBindingGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata54Template = AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*");
        this.metadata54 = mbuiContext.metadataRegistry().lookup(metadata54Template);
        AddressTemplate metadata53Template = AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*");
        this.metadata53 = mbuiContext.metadataRegistry().lookup(metadata53Template);
        AddressTemplate metadata52Template = AddressTemplate.of("/socket-binding-group=*");
        this.metadata52 = mbuiContext.metadataRegistry().lookup(metadata52Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-configuration-form", metadata52)
            .include("default-interface", "includes")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBindingGroup(changedValues))
            .prepareReset(form -> presenter.resetSocketBindingGroup(form))
            .build();
        outboundLocalForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-form", metadata53)
            .include("socket-binding-ref", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_LOCAL, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_LOCAL, form))
            .build();
        outboundLocalForm.getFormItem("socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        outboundRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-form", metadata54)
            .include("host", "port", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_REMOTE, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_REMOTE, form))
            .build();

        outboundLocalTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-table", metadata53)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_LOCAL), Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_LOCAL, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundRemoteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-table", metadata54)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_REMOTE), Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_REMOTE, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("host", (cell, type, row, meta) -> row.get("host").asString())
            .column("port", (cell, type, row, meta) -> row.get("port").asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html154;
        HTMLElement socketBindingGroupConfigurationItemElement = section()
            .add(html154 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Group</h1><p>${metadata52.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html154", html154);
        navigation.addPrimary("socket-binding-group-configuration-item", "Configuration", "pficon pficon-settings", socketBindingGroupConfigurationItemElement);
        HTMLElement html156;
        HTMLElement socketBindingGroupOutboundLocalItemElement = section()
            .add(html156 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Local</h1><p>${metadata53.getDescription().getDescription()}</p>"))
                            .element())
            .add(outboundLocalTable)
            .add(outboundLocalForm)
                    .element();
        expressionElements.put("html156", html156);
        navigation.addPrimary("socket-binding-group-outbound-local-item", "Outbound Local", "fa fa-arrow-circle-o-right", socketBindingGroupOutboundLocalItemElement);
        HTMLElement html159;
        HTMLElement socketBindingGroupOutboundRemoteItemElement = section()
            .add(html159 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Remote</h1><p>${metadata54.getDescription().getDescription()}</p>"))
                            .element())
            .add(outboundRemoteTable)
            .add(outboundRemoteForm)
                    .element();
        expressionElements.put("html159", html159);
        navigation.addPrimary("socket-binding-group-outbound-remote-item", "Outbound Remote", "fa fa-arrow-circle-right", socketBindingGroupOutboundRemoteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(outboundLocalTable);
        registerAttachable(outboundLocalForm);
        registerAttachable(outboundRemoteTable);
        registerAttachable(outboundRemoteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            outboundLocalTable.bindForm(outboundLocalForm);
            outboundRemoteTable.bindForm(outboundRemoteForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html154"), "${metadata52.getDescription().getDescription()}", String.valueOf(metadata52.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html156"), "${metadata53.getDescription().getDescription()}", String.valueOf(metadata53.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html159"), "${metadata54.getDescription().getDescription()}", String.valueOf(metadata54.getDescription().getDescription()));
    }
}
