package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata31;
    private final Metadata metadata28;
    private final Metadata metadata27;
    private final Metadata metadata20;
    private final Metadata metadata30;
    private final Metadata metadata29;
    private final Metadata metadata33;
    private final Metadata metadata21;
    private final Metadata metadata24;
    private final Metadata metadata23;
    private final Metadata metadata22;
    private final Metadata metadata25;
    private final Metadata metadata26;
    private final Metadata metadata32;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata31Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata31 = mbuiContext.metadataRegistry().lookup(metadata31Template);
        AddressTemplate metadata28Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata28 = mbuiContext.metadataRegistry().lookup(metadata28Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        AddressTemplate metadata20Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata20 = mbuiContext.metadataRegistry().lookup(metadata20Template);
        AddressTemplate metadata30Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*");
        this.metadata30 = mbuiContext.metadataRegistry().lookup(metadata30Template);
        AddressTemplate metadata29Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata29 = mbuiContext.metadataRegistry().lookup(metadata29Template);
        AddressTemplate metadata33Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata33 = mbuiContext.metadataRegistry().lookup(metadata33Template);
        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        AddressTemplate metadata23Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata23 = mbuiContext.metadataRegistry().lookup(metadata23Template);
        AddressTemplate metadata22Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata22 = mbuiContext.metadataRegistry().lookup(metadata22Template);
        AddressTemplate metadata25Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata25 = mbuiContext.metadataRegistry().lookup(metadata25Template);
        AddressTemplate metadata26Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata26 = mbuiContext.metadataRegistry().lookup(metadata26Template);
        AddressTemplate metadata32Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata32 = mbuiContext.metadataRegistry().lookup(metadata32Template);
        this.expressionElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata20)
            .onSave((form, changedValues) -> saveSingletonForm("Logging Configuration", metadata20Template.resolve(statementContext()), changedValues, metadata20))
            .prepareReset(form -> resetSingletonForm("Logging Configuration", metadata20Template.resolve(statementContext()), form, metadata20))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata21)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Root Logger", metadata21Template.resolve(statementContext()), changedValues, metadata21))
            .prepareReset(form -> resetSingletonForm("Root Logger", metadata21Template.resolve(statementContext()), form, metadata21))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-form", metadata22)
            .include("category", "filter-spec", "handlers", "level", "use-parent-handlers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Category", name, metadata22Template.resolve(statementContext(), name), changedValues, metadata22);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Category", name, metadata22Template.resolve(statementContext(), name), form, metadata22);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-form", metadata24)
            .include("autoflush", "enabled", "encoding", "filter-spec", "formatter", "level", "named-formatter", "target")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Console Handler", name, metadata24Template.resolve(statementContext(), name), changedValues, metadata24);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Console Handler", name, metadata24Template.resolve(statementContext(), name), form, metadata24);
            })
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-form", metadata26)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("named-formatter")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata26Template.resolve(statementContext(), name), changedValues, metadata26);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata26Template.resolve(statementContext(), name), form, metadata26);
            })
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-form", metadata27)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("named-formatter")
            .include("suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Rotating File Handler", name, metadata27Template.resolve(statementContext(), name), changedValues, metadata27);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Rotating File Handler", name, metadata27Template.resolve(statementContext(), name), form, metadata27);
            })
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata28)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("max-backup-index")
            .include("named-formatter")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Size Rotating File Handler", name, metadata28Template.resolve(statementContext(), name), changedValues, metadata28);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Size Rotating File Handler", name, metadata28Template.resolve(statementContext(), name), form, metadata28);
            })
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-form", metadata29)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("max-backup-index")
            .include("named-formatter")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Size Rotating File Handler", name, metadata29Template.resolve(statementContext(), name), changedValues, metadata29);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Size Rotating File Handler", name, metadata29Template.resolve(statementContext(), name), form, metadata29);
            })
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-form", metadata23)
            .include("filter-spec", "level", "overflow-action", "queue-length", "subhandlers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Async Handler", name, metadata23Template.resolve(statementContext(), name), changedValues, metadata23);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Async Handler", name, metadata23Template.resolve(statementContext(), name), form, metadata23);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-form", metadata25)
            .include("class", "enabled", "encoding", "filter-spec", "formatter", "level", "module", "named-formatter", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Handler", name, metadata25Template.resolve(statementContext(), name), changedValues, metadata25);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Handler", name, metadata25Template.resolve(statementContext(), name), form, metadata25);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), customHandlerFormTemplates));
        socketHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-socket-form", metadata30)
            .include("autoflush", "block-on-reconnect", "enabled", "encoding", "filter-spec", "level", "named-formatter", "outbound-socket-binding-ref", "protocol", "ssl-context")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Handler", name, metadata30Template.resolve(statementContext(), name), changedValues, metadata30);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Handler", name, metadata30Template.resolve(statementContext(), name), form, metadata30);
            })
            .build();
        List<AddressTemplate> socketHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        socketHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), socketHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-form", metadata31)
            .include("app-name", "enabled", "facility", "hostname", "level", "named-formatter", "port", "server-address", "syslog-format")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Syslog Handler", name, metadata31Template.resolve(statementContext(), name), changedValues, metadata31);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Syslog Handler", name, metadata31Template.resolve(statementContext(), name), form, metadata31);
            })
            .build();
        List<AddressTemplate> syslogHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        syslogHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), syslogHandlerFormTemplates));
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-form", metadata32)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Formatter", name, metadata32Template.resolve(statementContext(), name), changedValues, metadata32);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Formatter", name, metadata32Template.resolve(statementContext(), name), form, metadata32);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-form", metadata33)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Pattern Formatter", name, metadata33Template.resolve(statementContext(), name), changedValues, metadata33);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Pattern Formatter", name, metadata33Template.resolve(statementContext(), name), form, metadata33);
            })
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-table", metadata22)
            .button(mbuiContext.tableButtonFactory().add(metadata22Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-category-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata22,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata22Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Category", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), loggerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata22Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-table", metadata24)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-console-table", Ids.ADD), "Console Handler",
                metadata24Template, asList("level", "formatter", "target"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata24Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-table", metadata26)
            .button(mbuiContext.tableButtonFactory().add(metadata26Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-file-table", Ids.ADD),
                    metadata26)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata26Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata26Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-table", metadata27)
            .button(mbuiContext.tableButtonFactory().add(metadata27Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-rotating-file-table", Ids.ADD),
                    metadata27)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .include("suffix")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata27Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Periodic Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata27Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-table", metadata28)
            .button(mbuiContext.tableButtonFactory().add(metadata28Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-size-rotating-file-table", Ids.ADD),
                    metadata28)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .include("max-backup-index")
                    .include("rotate-size")
                    .include("suffix")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata28Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Periodic Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata28Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-table", metadata29)
            .button(mbuiContext.tableButtonFactory().add(metadata29Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-size-rotating-file-table", Ids.ADD),
                    metadata29)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .include("max-backup-index")
                    .include("rotate-size")
                    .include("suffix")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata29Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata29Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-table", metadata23)
            .button(mbuiContext.tableButtonFactory().add(metadata23Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-async-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata23,
                    asList("level", "overflow-action", "queue-length", "subhandlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata23Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Async Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), asyncHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata23Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-table", metadata25)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-custom-table", Ids.ADD), "Custom Handler",
                metadata25Template, asList("class", "formatter", "level", "module"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata25Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        socketHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-socket-table", metadata30)
            .button(mbuiContext.tableButtonFactory().add(metadata30Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-socket-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Socket Handler"),
                    metadata30,
                    asList("named-formatter", "outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata30Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Socket Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> socketHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
                dialog.getForm().getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), socketHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Socket Handler", metadata30Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-table", metadata31)
            .button(mbuiContext.tableButtonFactory().add(metadata31Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-syslog-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Syslog Handler"),
                    metadata31,
                    asList("app-name", "facility", "hostname", "level", "named-formatter", "port", "server-address", "syslog-format"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata31Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Syslog Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> syslogHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
                dialog.getForm().getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), syslogHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata31Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-table", metadata32)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-custom-table", Ids.ADD), "Custom Formatter",
                metadata32Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata32Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-table", metadata33)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-pattern-table", Ids.ADD), "Pattern Formatter",
                metadata33Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata33Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html57;
        HTMLElement loggingConfigItemElement = section()
            .add(html57 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata20.getDescription().getDescription()}</p>"))
                            .element())
            .add(loggingConfigForm)
                    .element();
        expressionElements.put("html57", html57);
        navigation.addPrimary("logging-config-item", "Configuration", "pficon pficon-settings", loggingConfigItemElement);
        HTMLElement html59;
        HTMLElement loggingRootLoggerItemElement = section()
            .add(html59 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">${metadata21.getDescription().getDescription()}</p>"))
                            .element())
            .add(rootLoggerForm)
                    .element();
        expressionElements.put("html59", html59);
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        HTMLElement html61;
        HTMLElement loggingCategoryItemElement = section()
            .add(html61 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata22.getDescription().getDescription()}</p>"))
                            .element())
            .add(loggerTable)
            .add(loggerForm)
                    .element();
        expressionElements.put("html61", html61);
        navigation.addPrimary("logging-category-item", "Categories", "pficon pficon-repository", loggingCategoryItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html64;
        HTMLElement loggingHandlerAsyncItemElement = section()
            .add(html64 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata23.getDescription().getDescription()}</p>"))
                                    .element())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
                            .element();
        expressionElements.put("html64", html64);
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        HTMLElement html67;
        HTMLElement loggingHandlerConsoleItemElement = section()
            .add(html67 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata24.getDescription().getDescription()}</p>"))
                                    .element())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
                            .element();
        expressionElements.put("html67", html67);
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        HTMLElement html70;
        HTMLElement loggingHandlerCustomItemElement = section()
            .add(html70 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata25.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customHandlerTable)
            .add(customHandlerForm)
                            .element();
        expressionElements.put("html70", html70);
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        HTMLElement html73;
        HTMLElement loggingHandlerFileItemElement = section()
            .add(html73 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata26.getDescription().getDescription()}</p>"))
                                    .element())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
                            .element();
        expressionElements.put("html73", html73);
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        HTMLElement html76;
        HTMLElement loggingHandlerPeriodicRotatingFileItemElement = section()
            .add(html76 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata27.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
                            .element();
        expressionElements.put("html76", html76);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        HTMLElement html79;
        HTMLElement loggingHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html79 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata28.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
                            .element();
        expressionElements.put("html79", html79);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html82;
        HTMLElement loggingHandlerSizeRotatingFileItemElement = section()
            .add(html82 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata29.getDescription().getDescription()}</p>"))
                                    .element())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
                            .element();
        expressionElements.put("html82", html82);
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        HTMLElement html85;
        HTMLElement loggingHandlerSocketItemElement = section()
            .add(html85 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Handler</h1><p>${metadata30.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketHandlerTable)
            .add(socketHandlerForm)
                            .element();
        expressionElements.put("html85", html85);
        navigation.addSecondary("logging-handler-item", "logging-handler-socket-item", "Socket Handler", loggingHandlerSocketItemElement);
        HTMLElement html88;
        HTMLElement loggingHandlerSyslogItemElement = section()
            .add(html88 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata31.getDescription().getDescription()}</p>"))
                                    .element())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
                            .element();
        expressionElements.put("html88", html88);
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html91;
        HTMLElement loggingFormatterCustomItemElement = section()
            .add(html91 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata32.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customFormatterTable)
            .add(customFormatterForm)
                            .element();
        expressionElements.put("html91", html91);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);
        HTMLElement html94;
        HTMLElement loggingFormatterPatternItemElement = section()
            .add(html94 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata33.getDescription().getDescription()}</p>"))
                                    .element())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
                            .element();
        expressionElements.put("html94", html94);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(socketHandlerTable);
        registerAttachable(socketHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            socketHandlerTable.bindForm(socketHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html57"), "${metadata20.getDescription().getDescription()}", String.valueOf(metadata20.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html59"), "${metadata21.getDescription().getDescription()}", String.valueOf(metadata21.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html61"), "${metadata22.getDescription().getDescription()}", String.valueOf(metadata22.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html64"), "${metadata23.getDescription().getDescription()}", String.valueOf(metadata23.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html67"), "${metadata24.getDescription().getDescription()}", String.valueOf(metadata24.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html70"), "${metadata25.getDescription().getDescription()}", String.valueOf(metadata25.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html73"), "${metadata26.getDescription().getDescription()}", String.valueOf(metadata26.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html76"), "${metadata27.getDescription().getDescription()}", String.valueOf(metadata27.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html79"), "${metadata28.getDescription().getDescription()}", String.valueOf(metadata28.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html82"), "${metadata29.getDescription().getDescription()}", String.valueOf(metadata29.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html85"), "${metadata30.getDescription().getDescription()}", String.valueOf(metadata30.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html88"), "${metadata31.getDescription().getDescription()}", String.valueOf(metadata31.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html91"), "${metadata32.getDescription().getDescription()}", String.valueOf(metadata32.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html94"), "${metadata33.getDescription().getDescription()}", String.valueOf(metadata33.getDescription().getDescription()));
    }
}
