package org.jboss.hal.client.configuration.subsystem.transaction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_TransactionView extends TransactionView {

    private final Metadata metadata46;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_TransactionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata46Template = AddressTemplate.of("/{selected.profile}/subsystem=transactions");
        this.metadata46 = mbuiContext.metadataRegistry().lookup(metadata46Template);
        this.expressionElements = new HashMap<>();

        attributesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-attributes-form", metadata46)
            .include("default-timeout", "enable-tsm-status", "journal-store-enable-async-io", "jts", "maximum-timeout", "node-identifier", "statistics-enabled", "use-journal-store")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Transaction Manager", metadata46Template.resolve(statementContext()), changedValues, metadata46))
            .prepareReset(form -> resetSingletonForm("Transaction Manager", metadata46Template.resolve(statementContext()), form, metadata46))
            .build();
        processForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-process-form", metadata46)
            .include("process-id-uuid", "process-id-socket-binding", "process-id-socket-max-ports")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Process ID", metadata46Template.resolve(statementContext()), changedValues, metadata46))
            .prepareReset(form -> resetSingletonForm("Process ID", metadata46Template.resolve(statementContext()), form, metadata46))
            .build();
        processForm.getFormItem("process-id-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-recovery-form", metadata46)
            .include("socket-binding", "status-socket-binding", "recovery-listener")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Recovery", metadata46Template.resolve(statementContext()), changedValues, metadata46))
            .prepareReset(form -> resetSingletonForm("Recovery", metadata46Template.resolve(statementContext()), form, metadata46))
            .build();
        recoveryForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm.getFormItem("status-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        pathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-path-form", metadata46)
            .include("object-store-path", "object-store-relative-to")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Path", metadata46Template.resolve(statementContext()), changedValues, metadata46))
            .prepareReset(form -> resetSingletonForm("Path", metadata46Template.resolve(statementContext()), form, metadata46))
            .build();
        pathForm.getFormItem("object-store-relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        jdbcForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-jdbc-form", metadata46)
            .include("use-jdbc-store", "jdbc-action-store-drop-table", "jdbc-action-store-table-prefix", "jdbc-communication-store-drop-table", "jdbc-communication-store-table-prefix", "jdbc-state-store-drop-table", "jdbc-state-store-table-prefix", "jdbc-store-datasource")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("JDBC", metadata46Template.resolve(statementContext()), changedValues, metadata46))
            .prepareReset(form -> resetSingletonForm("JDBC", metadata46Template.resolve(statementContext()), form, metadata46))
            .build();
        List<AddressTemplate> jdbcFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        jdbcForm.getFormItem("jdbc-store-datasource").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), jdbcFormTemplates));


        navigation = new VerticalNavigation();
        HTMLElement html129;
        HTMLElement txAttributesConfigItemElement = section()
            .add(html129 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Transaction Manager</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                            .element())
            .add(attributesForm)
                    .element();
        expressionElements.put("html129", html129);
        navigation.addPrimary("tx-attributes-config-item", "Configuration", "pficon pficon-settings", txAttributesConfigItemElement);
        HTMLElement html131;
        HTMLElement txProcessItemElement = section()
            .add(html131 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process ID</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                            .element())
            .add(processForm)
                    .element();
        expressionElements.put("html131", html131);
        navigation.addPrimary("tx-process-item", "Process", "pficon pficon-service", txProcessItemElement);
        HTMLElement html133;
        HTMLElement txRecoveryConfigItemElement = section()
            .add(html133 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Recovery</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                            .element())
            .add(recoveryForm)
                    .element();
        expressionElements.put("html133", html133);
        navigation.addPrimary("tx-recovery-config-item", "Recovery", "fa fa-repeat", txRecoveryConfigItemElement);
        HTMLElement html135;
        HTMLElement txPathConfigItemElement = section()
            .add(html135 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Path</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                            .element())
            .add(pathForm)
                    .element();
        expressionElements.put("html135", html135);
        navigation.addPrimary("tx-path-config-item", "Path", "fa fa-folder-open", txPathConfigItemElement);
        HTMLElement html137;
        HTMLElement txJdbcConfigItemElement = section()
            .add(html137 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                            .element())
            .add(jdbcForm)
                    .element();
        expressionElements.put("html137", html137);
        navigation.addPrimary("tx-jdbc-config-item", "JDBC", "fa fa-database", txJdbcConfigItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(attributesForm);
        registerAttachable(processForm);
        registerAttachable(recoveryForm);
        registerAttachable(pathForm);
        registerAttachable(jdbcForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        ExpressionUtil.replaceExpression(expressionElements.get("html129"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html131"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html133"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html135"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html137"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
    }
}
