package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata104;
    private final Metadata metadata105;
    private final Metadata metadata103;
    private final Metadata metadata107;
    private final Metadata metadata106;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata104Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata104 = mbuiContext.metadataRegistry().lookup(metadata104Template);
        AddressTemplate metadata105Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata105 = mbuiContext.metadataRegistry().lookup(metadata105Template);
        AddressTemplate metadata103Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata103 = mbuiContext.metadataRegistry().lookup(metadata103Template);
        AddressTemplate metadata107Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata107 = mbuiContext.metadataRegistry().lookup(metadata107Template);
        AddressTemplate metadata106Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata106 = mbuiContext.metadataRegistry().lookup(metadata106Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata103)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata103Template.resolve(statementContext()), changedValues, metadata103))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata103Template.resolve(statementContext()), form, metadata103))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata104)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata104Template.resolve(statementContext(), name), changedValues, metadata104);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata104Template.resolve(statementContext(), name), form, metadata104);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata105)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata105Template.resolve(statementContext(), name), changedValues, metadata105);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata105Template.resolve(statementContext(), name), form, metadata105);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata106)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata106Template.resolve(statementContext(), name), changedValues, metadata106);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata106Template.resolve(statementContext(), name), form, metadata106);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata107)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata107Template.resolve(statementContext(), name), changedValues, metadata107);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata107Template.resolve(statementContext(), name), form, metadata107);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata104)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata104Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata104Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata105)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "JVM",
                metadata105Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata105Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata106)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata106Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata106Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata107)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata107Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata107Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html308;
        HTMLElement serverConfigurationItemElement = section()
            .add(html308 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata103.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverConfigurationForm)
                    .element();
        expressionElements.put("html308", html308);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html310;
        HTMLElement serverInterfaceItemElement = section()
            .add(html310 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata104.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
                    .element();
        expressionElements.put("html310", html310);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html313;
        HTMLElement serverJvmItemElement = section()
            .add(html313 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata105.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverJvmTable)
            .add(serverJvmForm)
                    .element();
        expressionElements.put("html313", html313);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html316;
        HTMLElement serverPathItemElement = section()
            .add(html316 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata106.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverPathTable)
            .add(serverPathForm)
                    .element();
        expressionElements.put("html316", html316);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html319;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html319 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata107.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
                    .element();
        expressionElements.put("html319", html319);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html308"), "${metadata103.getDescription().getDescription()}", String.valueOf(metadata103.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html310"), "${metadata104.getDescription().getDescription()}", String.valueOf(metadata104.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html313"), "${metadata105.getDescription().getDescription()}", String.valueOf(metadata105.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html316"), "${metadata106.getDescription().getDescription()}", String.valueOf(metadata106.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html319"), "${metadata107.getDescription().getDescription()}", String.valueOf(metadata107.getDescription().getDescription()));
    }
}
