package org.jboss.hal.core.runtime;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class NonProgressingOperationEvent extends GwtEvent<NonProgressingOperationEvent.NonProgressingOperationHandler> { 

  boolean nonProgressingOperation;

  protected NonProgressingOperationEvent() {
    // Possibly for serialization.
  }

  public NonProgressingOperationEvent(boolean nonProgressingOperation) {
    this.nonProgressingOperation = nonProgressingOperation;
  }

  public static void fire(HasHandlers source, boolean nonProgressingOperation) {
    NonProgressingOperationEvent eventInstance = new NonProgressingOperationEvent(nonProgressingOperation);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, NonProgressingOperationEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasNonProgressingOperationHandlers extends HasHandlers {
    HandlerRegistration addNonProgressingOperationHandler(NonProgressingOperationHandler handler);
  }

  public interface NonProgressingOperationHandler extends EventHandler {
    public void onNonProgressingOperation(NonProgressingOperationEvent event);
  }

  private static final Type<NonProgressingOperationHandler> TYPE = new Type<NonProgressingOperationHandler>();

  public static Type<NonProgressingOperationHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<NonProgressingOperationHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(NonProgressingOperationHandler handler) {
    handler.onNonProgressingOperation(this);
  }

  public boolean isNonProgressingOperation(){
    return nonProgressingOperation;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    NonProgressingOperationEvent other = (NonProgressingOperationEvent) obj;
    if (nonProgressingOperation != other.nonProgressingOperation)
        return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + new Boolean(nonProgressingOperation).hashCode();
    return hashCode;
  }

  @Override
  public String toString() {
    return "NonProgressingOperationEvent["
                 + nonProgressingOperation
    + "]";
  }
}
