package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata49;
    private final Metadata metadata46;
    private final Metadata metadata44;
    private final Metadata metadata48;
    private final Metadata metadata47;
    private final Metadata metadata41;
    private final Metadata metadata45;
    private final Metadata metadata39;
    private final Metadata metadata43;
    private final Metadata metadata38;
    private final Metadata metadata42;
    private final Metadata metadata40;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata49Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata49 = mbuiContext.metadataRegistry().lookup(metadata49Template);
        AddressTemplate metadata46Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata46 = mbuiContext.metadataRegistry().lookup(metadata46Template);
        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        AddressTemplate metadata48Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata48 = mbuiContext.metadataRegistry().lookup(metadata48Template);
        AddressTemplate metadata47Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata47 = mbuiContext.metadataRegistry().lookup(metadata47Template);
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        AddressTemplate metadata45Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=identity");
        this.metadata45 = mbuiContext.metadataRegistry().lookup(metadata45Template);
        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        AddressTemplate metadata38Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata38 = mbuiContext.metadataRegistry().lookup(metadata38Template);
        AddressTemplate metadata42Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata42 = mbuiContext.metadataRegistry().lookup(metadata42Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-configuration-form", metadata38)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata38Template.resolve(statementContext()), changedValues, metadata38))
            .prepareReset(form -> resetSingletonForm("Container", metadata38Template.resolve(statementContext()), form, metadata38))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-form", metadata39)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata39Template.resolve(statementContext(), name), changedValues, metadata39);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata39Template.resolve(statementContext(), name), form, metadata39);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-form", metadata40)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata40Template.resolve(statementContext(), name), changedValues, metadata40);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Remoting Profile", name, metadata40Template.resolve(statementContext(), name), form, metadata40);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-form", metadata41)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata41Template.resolve(statementContext(), name), changedValues, metadata41);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Bean Pool", name, metadata41Template.resolve(statementContext(), name), form, metadata41);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-form", metadata42)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata42Template.resolve(statementContext(), name), changedValues, metadata42);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Cache", name, metadata42Template.resolve(statementContext(), name), form, metadata42);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-form", metadata43)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata43Template.resolve(statementContext(), name), changedValues, metadata43);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Passivation", name, metadata43Template.resolve(statementContext(), name), form, metadata43);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-async-form", metadata44)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata44Template.resolve(statementContext()), changedValues, metadata44))
            .prepareReset(form -> resetSingletonForm("Async", metadata44Template.resolve(statementContext()), form, metadata44))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIdentityForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-identity-form", metadata45)
            .singleton(
                () -> new Operation.Builder(metadata45Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-identity-form", "Identity", metadata45Template))
            .prepareRemove(form -> removeSingletonForm("Identity", metadata45Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Identity", metadata45Template.resolve(statementContext()), changedValues, metadata45))
            .prepareReset(form -> resetSingletonForm("Identity", metadata45Template.resolve(statementContext()), form, metadata45))
            .build();
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-iiop-form", metadata46)
            .singleton(
                () -> new Operation.Builder(metadata46Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-iiop-form", "IIOP", metadata46Template))
            .prepareRemove(form -> removeSingletonForm("IIOP", metadata46Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata46Template.resolve(statementContext()), changedValues, metadata46))
            .prepareReset(form -> resetSingletonForm("IIOP", metadata46Template.resolve(statementContext()), form, metadata46))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-remote-form", metadata47)
            .include("connectors", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata47Template.resolve(statementContext()), changedValues, metadata47))
            .prepareReset(form -> resetSingletonForm("Remote", metadata47Template.resolve(statementContext()), form, metadata47))
            .build();
        List<AddressTemplate> serviceRemoteFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*"));
        serviceRemoteForm.getFormItem("connectors").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), serviceRemoteFormTemplates));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-timer-form", metadata48)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata48Template.resolve(statementContext()), changedValues, metadata48))
            .prepareReset(form -> resetSingletonForm("Timer", metadata48Template.resolve(statementContext()), form, metadata48))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-form", metadata49)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata49Template.resolve(statementContext(), name), changedValues, metadata49);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("MDB Delivery Group", name, metadata49Template.resolve(statementContext(), name), form, metadata49);
            })
            .build();

        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-table", metadata39)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata39Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata39Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-table", metadata40)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-remoting-profile-table", Ids.ADD), "Remoting Profile",
                metadata40Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata40Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-table", metadata41)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-bean-pool-table", Ids.ADD), "Bean Pool",
                metadata41Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata41Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-table", metadata42)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-cache-table", Ids.ADD), "Cache",
                metadata42Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata42Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-table", metadata43)
            .button(mbuiContext.tableButtonFactory().add(metadata43Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb3-passivation-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata43,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata43Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata43Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-table", metadata49)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-mdb-delivery-group-table", Ids.ADD), "MDB Delivery Group",
                metadata49Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata49Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb3-container-item", "Container", "fa fa-cogs");
        HTMLElement html109;
        HTMLElement ejb3ConfigurationItemElement = section()
            .add(html109 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>${metadata38.getDescription().getDescription()}</p>"))
                                    .element())
            .add(configurationForm)
                            .element();
        expressionElements.put("html109", html109);
        navigation.addSecondary("ejb3-container-item", "ejb3-configuration-item", "Container", ejb3ConfigurationItemElement);
        HTMLElement html111;
        HTMLElement ejb3ThreadPoolItemElement = section()
            .add(html111 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata39.getDescription().getDescription()}</p>"))
                                    .element())
            .add(threadPoolTable)
            .add(threadPoolForm)
                            .element();
        expressionElements.put("html111", html111);
        navigation.addSecondary("ejb3-container-item", "ejb3-thread-pool-item", "Thread Pool", ejb3ThreadPoolItemElement);
        HTMLElement html114;
        HTMLElement ejb3RemotingProfileItemElement = section()
            .add(html114 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>${metadata40.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remotingProfileTable)
            .add(remotingProfileForm)
                            .element();
        expressionElements.put("html114", html114);
        navigation.addSecondary("ejb3-container-item", "ejb3-remoting-profile-item", "Remoting Profile", ejb3RemotingProfileItemElement);
        HTMLElement html117;
        HTMLElement ejb3BeanPoolItemElement = section()
            .add(html117 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>${metadata41.getDescription().getDescription()}</p>"))
                            .element())
            .add(beanPoolTable)
            .add(beanPoolForm)
                    .element();
        expressionElements.put("html117", html117);
        navigation.addPrimary("ejb3-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejb3BeanPoolItemElement);
        navigation.addPrimary("ejb3-state-item", "State Management", "fa fa-list-ul");
        HTMLElement html120;
        HTMLElement ejb3CacheItemElement = section()
            .add(html120 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>${metadata42.getDescription().getDescription()}</p>"))
                                    .element())
            .add(cacheTable)
            .add(cacheForm)
                            .element();
        expressionElements.put("html120", html120);
        navigation.addSecondary("ejb3-state-item", "ejb3-cache-item", "Cache", ejb3CacheItemElement);
        HTMLElement html123;
        HTMLElement ejb3PassivationItemElement = section()
            .add(html123 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>${metadata43.getDescription().getDescription()}</p>"))
                                    .element())
            .add(passivationTable)
            .add(passivationForm)
                            .element();
        expressionElements.put("html123", html123);
        navigation.addSecondary("ejb3-state-item", "ejb3-passivation-item", "Passivation", ejb3PassivationItemElement);
        navigation.addPrimary("ejb3-service-item", "Services", "pficon pficon-service");
        HTMLElement html126;
        HTMLElement ejb3ServiceAsyncItemElement = section()
            .add(html126 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>${metadata44.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceAsyncForm)
                            .element();
        expressionElements.put("html126", html126);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-async-item", "Async", ejb3ServiceAsyncItemElement);
        HTMLElement html128;
        HTMLElement ejb3ServiceIdentityItemElement = section()
            .add(html128 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Identity</h1><p>${metadata45.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceIdentityForm)
                            .element();
        expressionElements.put("html128", html128);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-identity-item", "Identity", ejb3ServiceIdentityItemElement);
        HTMLElement html130;
        HTMLElement ejb3ServiceIiopItemElement = section()
            .add(html130 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceIiopForm)
                            .element();
        expressionElements.put("html130", html130);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-iiop-item", "IIOP", ejb3ServiceIiopItemElement);
        HTMLElement html132;
        HTMLElement ejb3ServiceRemoteItemElement = section()
            .add(html132 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>${metadata47.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceRemoteForm)
                            .element();
        expressionElements.put("html132", html132);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-remote-item", "Remote", ejb3ServiceRemoteItemElement);
        HTMLElement html134;
        HTMLElement ejb3ServiceTimerItemElement = section()
            .add(html134 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>${metadata48.getDescription().getDescription()}</p>"))
                                    .element())
            .add(serviceTimerForm)
                            .element();
        expressionElements.put("html134", html134);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-timer-item", "Timer", ejb3ServiceTimerItemElement);
        HTMLElement html136;
        HTMLElement ejb3MdbDeliveryGroupItemElement = section()
            .add(html136 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>${metadata49.getDescription().getDescription()}</p>"))
                            .element())
            .add(mdbDeliveryGroupTable)
            .add(mdbDeliveryGroupForm)
                    .element();
        expressionElements.put("html136", html136);
        navigation.addPrimary("ejb3-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejb3MdbDeliveryGroupItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIdentityForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html109"), "${metadata38.getDescription().getDescription()}", String.valueOf(metadata38.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html111"), "${metadata39.getDescription().getDescription()}", String.valueOf(metadata39.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html114"), "${metadata40.getDescription().getDescription()}", String.valueOf(metadata40.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html117"), "${metadata41.getDescription().getDescription()}", String.valueOf(metadata41.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html120"), "${metadata42.getDescription().getDescription()}", String.valueOf(metadata42.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html123"), "${metadata43.getDescription().getDescription()}", String.valueOf(metadata43.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html126"), "${metadata44.getDescription().getDescription()}", String.valueOf(metadata44.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html128"), "${metadata45.getDescription().getDescription()}", String.valueOf(metadata45.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html130"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html132"), "${metadata47.getDescription().getDescription()}", String.valueOf(metadata47.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html134"), "${metadata48.getDescription().getDescription()}", String.valueOf(metadata48.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html136"), "${metadata49.getDescription().getDescription()}", String.valueOf(metadata49.getDescription().getDescription()));
    }
}
