package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingProfileView extends LoggingProfileView {

    private final org.jboss.hal.core.CrudOperations crud;
    private final Metadata metadata131;
    private final Metadata metadata127;
    private final Metadata metadata130;
    private final Metadata metadata125;
    private final Metadata metadata124;
    private final Metadata metadata119;
    private final Metadata metadata128;
    private final Metadata metadata123;
    private final Metadata metadata121;
    private final Metadata metadata122;
    private final Metadata metadata120;
    private final Metadata metadata129;
    private final Metadata metadata126;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingProfileView(MbuiContext mbuiContext, org.jboss.hal.core.CrudOperations crud) {
        super(mbuiContext);

        this.crud = crud;
        AddressTemplate metadata131Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*");
        this.metadata131 = mbuiContext.metadataRegistry().lookup(metadata131Template);
        AddressTemplate metadata127Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*");
        this.metadata127 = mbuiContext.metadataRegistry().lookup(metadata127Template);
        AddressTemplate metadata130Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*");
        this.metadata130 = mbuiContext.metadataRegistry().lookup(metadata130Template);
        AddressTemplate metadata125Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*");
        this.metadata125 = mbuiContext.metadataRegistry().lookup(metadata125Template);
        AddressTemplate metadata124Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/file-handler=*");
        this.metadata124 = mbuiContext.metadataRegistry().lookup(metadata124Template);
        AddressTemplate metadata119Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/root-logger=ROOT");
        this.metadata119 = mbuiContext.metadataRegistry().lookup(metadata119Template);
        AddressTemplate metadata128Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/socket-handler=*");
        this.metadata128 = mbuiContext.metadataRegistry().lookup(metadata128Template);
        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/async-handler=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/console-handler=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata120Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/logger=*");
        this.metadata120 = mbuiContext.metadataRegistry().lookup(metadata120Template);
        AddressTemplate metadata129Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*");
        this.metadata129 = mbuiContext.metadataRegistry().lookup(metadata129Template);
        AddressTemplate metadata126Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*");
        this.metadata126 = mbuiContext.metadataRegistry().lookup(metadata126Template);
        this.expressionElements = new HashMap<>();

        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-profile-root-logger-form", metadata119)
            .include("filter-spec", "handlers", "level")
            .unsorted()
            .onSave((form, changedValues) -> saveRootLogger(form, changedValues))
            .prepareReset(form -> resetRootLogger(form))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-form", metadata120)
            .include("category", "filter-spec", "handlers", "level", "use-parent-handlers")
            .unsorted()
            .onSave((form, changedValues) -> saveLogger(form, changedValues))
            .prepareReset(form -> resetLogger(form))
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-form", metadata122)
            .include("autoflush", "enabled", "encoding", "filter-spec", "formatter", "level", "named-formatter", "target")
            .unsorted()
            .onSave((form, changedValues) -> saveConsoleHandler(form, changedValues))
            .prepareReset(form -> resetConsoleHandler(form))
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-form", metadata124)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "named-formatter")
            .unsorted()
            .onSave((form, changedValues) -> saveFileHandler(form, changedValues))
            .prepareReset(form -> resetFileHandler(form))
            .build();
        fileHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-form", metadata125)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "named-formatter", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicHandler(form))
            .build();
        periodicHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-form", metadata126)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "max-backup-index", "named-formatter", "rotate-size", "rotate-on-boot", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicSizeHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicSizeHandler(form))
            .build();
        periodicSizeHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-form", metadata127)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "max-backup-index", "named-formatter", "rotate-size", "rotate-on-boot", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> saveSizeHandler(form, changedValues))
            .prepareReset(form -> resetSizeHandler(form))
            .build();
        sizeHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-form", metadata121)
            .include("filter-spec", "level", "overflow-action", "queue-length", "subhandlers")
            .unsorted()
            .onSave((form, changedValues) -> saveAsyncHandler(form, changedValues))
            .prepareReset(form -> resetAsyncHandler(form))
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-form", metadata123)
            .include("enabled", "encoding", "class", "filter-spec", "formatter", "level", "module", "named-formatter", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomHandler(form, changedValues))
            .prepareReset(form -> resetCustomHandler(form))
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), customHandlerFormTemplates));
        socketHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-socket-form", metadata128)
            .include("autoflush", "block-on-reconnect", "enabled", "encoding", "filter-spec", "level", "named-formatter", "outbound-socket-binding-ref", "protocol", "ssl-context")
            .unsorted()
            .onSave((form, changedValues) -> saveSocketHandler(form, changedValues))
            .prepareReset(form -> resetSocketHandler(form))
            .build();
        List<AddressTemplate> socketHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        socketHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), socketHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-form", metadata129)
            .include("app-name", "enabled", "facility", "hostname", "level", "named-formatter", "port", "server-address", "syslog-format")
            .unsorted()
            .onSave((form, changedValues) -> saveSyslogHandler(form, changedValues))
            .prepareReset(form -> resetSyslogHandler(form))
            .build();
        List<AddressTemplate> syslogHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        syslogHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), syslogHandlerFormTemplates));
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-form", metadata130)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomFormatter(form, changedValues))
            .prepareReset(form -> resetCustomFormatter(form))
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-form", metadata131)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> savePatternFormatter(form, changedValues))
            .prepareReset(form -> resetPatternFormatter(form))
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-table", metadata120)
            .button(mbuiContext.resources().constants().add(), table -> addLogger(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeLogger(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:remove)"))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-table", metadata122)
            .button(mbuiContext.resources().constants().add(), table -> addConsoleHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeConsoleHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:remove)"))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-table", metadata124)
            .button(mbuiContext.resources().constants().add(), table -> addFileHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeFileHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-table", metadata125)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-table", metadata126)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-table", metadata127)
            .button(mbuiContext.resources().constants().add(), table -> addSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-table", metadata121)
            .button(mbuiContext.resources().constants().add(), table -> addAsyncHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeAsyncHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:remove)"))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-table", metadata123)
            .button(mbuiContext.resources().constants().add(), table -> addCustomHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:remove)"))
            .columns("name", "level")
            .build();
        socketHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-socket-table", metadata128)
            .button(mbuiContext.resources().constants().add(), table -> addSocketHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/socket-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSocketHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/socket-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-table", metadata129)
            .button(mbuiContext.resources().constants().add(), table -> addSyslogHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSyslogHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-table", metadata130)
            .button(mbuiContext.resources().constants().add(), table -> addCustomFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-table", metadata131)
            .button(mbuiContext.resources().constants().add(), table -> addPatternFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePatternFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html355;
        HTMLElement loggingProfileRootLoggerItemElement = section()
            .add(html355 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-profile-root-logger-header\">Root Logger</h1><p id=\"logging-profile-root-logger-description\">${metadata119.getDescription().getDescription()}</p>"))
                            .element())
            .add(rootLoggerForm)
                    .element();
        expressionElements.put("html355", html355);
        navigation.addPrimary("logging-profile-root-logger-item", "Root Logger", "fa fa-sitemap", loggingProfileRootLoggerItemElement);
        HTMLElement html357;
        HTMLElement loggingProfileCategoryItemElement = section()
            .add(html357 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata120.getDescription().getDescription()}</p>"))
                            .element())
            .add(loggerTable)
            .add(loggerForm)
                    .element();
        expressionElements.put("html357", html357);
        navigation.addPrimary("logging-profile-category-item", "Categories", "pficon pficon-repository", loggingProfileCategoryItemElement);
        navigation.addPrimary("logging-profile-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html360;
        HTMLElement loggingProfileHandlerAsyncItemElement = section()
            .add(html360 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata121.getDescription().getDescription()}</p>"))
                                    .element())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
                            .element();
        expressionElements.put("html360", html360);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-async-item", "Async Handler", loggingProfileHandlerAsyncItemElement);
        HTMLElement html363;
        HTMLElement loggingProfileHandlerConsoleItemElement = section()
            .add(html363 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata122.getDescription().getDescription()}</p>"))
                                    .element())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
                            .element();
        expressionElements.put("html363", html363);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-console-item", "Console Handler", loggingProfileHandlerConsoleItemElement);
        HTMLElement html366;
        HTMLElement loggingProfileHandlerCustomItemElement = section()
            .add(html366 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata123.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customHandlerTable)
            .add(customHandlerForm)
                            .element();
        expressionElements.put("html366", html366);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-custom-item", "Custom Handler", loggingProfileHandlerCustomItemElement);
        HTMLElement html369;
        HTMLElement loggingProfileHandlerFileItemElement = section()
            .add(html369 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata124.getDescription().getDescription()}</p>"))
                                    .element())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
                            .element();
        expressionElements.put("html369", html369);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-file-item", "File Handler", loggingProfileHandlerFileItemElement);
        HTMLElement html372;
        HTMLElement loggingProfileHandlerPeriodicRotatingFileItemElement = section()
            .add(html372 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata125.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
                            .element();
        expressionElements.put("html372", html372);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-rotating-file-item", "Periodic Handler", loggingProfileHandlerPeriodicRotatingFileItemElement);
        HTMLElement html375;
        HTMLElement loggingProfileHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html375 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata126.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
                            .element();
        expressionElements.put("html375", html375);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingProfileHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html378;
        HTMLElement loggingProfileHandlerSizeRotatingFileItemElement = section()
            .add(html378 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata127.getDescription().getDescription()}</p>"))
                                    .element())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
                            .element();
        expressionElements.put("html378", html378);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-size-rotating-file-item", "Size Handler", loggingProfileHandlerSizeRotatingFileItemElement);
        HTMLElement html381;
        HTMLElement loggingProfileHandlerSocketItemElement = section()
            .add(html381 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Handler</h1><p>${metadata128.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketHandlerTable)
            .add(socketHandlerForm)
                            .element();
        expressionElements.put("html381", html381);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-socket-item", "Socket Handler", loggingProfileHandlerSocketItemElement);
        HTMLElement html384;
        HTMLElement loggingProfileHandlerSyslogItemElement = section()
            .add(html384 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata129.getDescription().getDescription()}</p>"))
                                    .element())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
                            .element();
        expressionElements.put("html384", html384);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-syslog-item", "Syslog Handler", loggingProfileHandlerSyslogItemElement);
        navigation.addPrimary("logging-profile-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html387;
        HTMLElement loggingProfileFormatterCustomItemElement = section()
            .add(html387 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata130.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customFormatterTable)
            .add(customFormatterForm)
                            .element();
        expressionElements.put("html387", html387);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-custom-item", "Custom Formatter", loggingProfileFormatterCustomItemElement);
        HTMLElement html390;
        HTMLElement loggingProfileFormatterPatternItemElement = section()
            .add(html390 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata131.getDescription().getDescription()}</p>"))
                                    .element())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
                            .element();
        expressionElements.put("html390", html390);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-pattern-item", "Pattern Formatter", loggingProfileFormatterPatternItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(socketHandlerTable);
        registerAttachable(socketHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.core.CrudOperations crud() {
    return crud;
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            socketHandlerTable.bindForm(socketHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html355"), "${metadata119.getDescription().getDescription()}", String.valueOf(metadata119.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html357"), "${metadata120.getDescription().getDescription()}", String.valueOf(metadata120.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html360"), "${metadata121.getDescription().getDescription()}", String.valueOf(metadata121.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html363"), "${metadata122.getDescription().getDescription()}", String.valueOf(metadata122.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html366"), "${metadata123.getDescription().getDescription()}", String.valueOf(metadata123.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html369"), "${metadata124.getDescription().getDescription()}", String.valueOf(metadata124.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html372"), "${metadata125.getDescription().getDescription()}", String.valueOf(metadata125.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html375"), "${metadata126.getDescription().getDescription()}", String.valueOf(metadata126.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html378"), "${metadata127.getDescription().getDescription()}", String.valueOf(metadata127.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html381"), "${metadata128.getDescription().getDescription()}", String.valueOf(metadata128.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html384"), "${metadata129.getDescription().getDescription()}", String.valueOf(metadata129.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html387"), "${metadata130.getDescription().getDescription()}", String.valueOf(metadata130.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html390"), "${metadata131.getDescription().getDescription()}", String.valueOf(metadata131.getDescription().getDescription()));
    }
}
