package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata61;
    private final Metadata metadata64;
    private final Metadata metadata62;
    private final Metadata metadata60;
    private final Metadata metadata65;
    private final Metadata metadata63;
    private final Metadata metadata59;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        AddressTemplate metadata64Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata64 = mbuiContext.metadataRegistry().lookup(metadata64Template);
        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata65Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata65 = mbuiContext.metadataRegistry().lookup(metadata65Template);
        AddressTemplate metadata63Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata63 = mbuiContext.metadataRegistry().lookup(metadata63Template);
        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata59)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata59Template.resolve(statementContext()), changedValues, metadata59))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata59Template.resolve(statementContext()), form, metadata59))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata60)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata60Template.resolve(statementContext(), name), changedValues, metadata60);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata60Template.resolve(statementContext(), name), form, metadata60);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata61)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata61Template.resolve(statementContext(), name), changedValues, metadata61);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata61Template.resolve(statementContext(), name), form, metadata61);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata62)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata62Template.resolve(statementContext(), name), changedValues, metadata62);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata62Template.resolve(statementContext(), name), form, metadata62);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata63)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata63Template.resolve(statementContext(), name), changedValues, metadata63);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata63Template.resolve(statementContext(), name), form, metadata63);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata64)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata64Template.resolve(statementContext(), name), changedValues, metadata64);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata64Template.resolve(statementContext(), name), form, metadata64);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata65)
            .singleton(
                () -> new Operation.Builder(metadata65Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata65Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata65Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata65Template.resolve(statementContext()), changedValues, metadata65))
            .prepareReset(form -> resetSingletonForm("Vault", metadata65Template.resolve(statementContext()), form, metadata65))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata60)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD), "Elytron Key Manager",
                metadata60Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata60Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata61)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD), "Elytron Key Store",
                metadata61Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata61Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata62)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD), "Elytron Realm",
                metadata62Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata62Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata63)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD), "Elytron Trust Manager",
                metadata63Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata63Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata64)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD), "Elytron Trust Store",
                metadata64Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata64Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html174;
        HTMLElement securityConfigurationItemElement = section()
            .add(html174 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata59.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html174", html174);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html176;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html176 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyManagerTable)
            .add(keyManagerForm)
                    .element();
        expressionElements.put("html176", html176);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html179;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html179 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>${metadata61.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyStoreTable)
            .add(keyStoreForm)
                    .element();
        expressionElements.put("html179", html179);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html182;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html182 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>${metadata62.getDescription().getDescription()}</p>"))
                            .element())
            .add(realmTable)
            .add(realmForm)
                    .element();
        expressionElements.put("html182", html182);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html185;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html185 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>${metadata63.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustManagerTable)
            .add(trustManagerForm)
                    .element();
        expressionElements.put("html185", html185);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html188;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html188 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>${metadata64.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustStoreTable)
            .add(trustStoreForm)
                    .element();
        expressionElements.put("html188", html188);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html191;
        HTMLElement securityVaultItemElement = section()
            .add(html191 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>${metadata65.getDescription().getDescription()}</p>"))
                            .element())
            .add(vaultForm)
                    .element();
        expressionElements.put("html191", html191);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html174"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html176"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html179"), "${metadata61.getDescription().getDescription()}", String.valueOf(metadata61.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html182"), "${metadata62.getDescription().getDescription()}", String.valueOf(metadata62.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html185"), "${metadata63.getDescription().getDescription()}", String.valueOf(metadata63.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html188"), "${metadata64.getDescription().getDescription()}", String.valueOf(metadata64.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html191"), "${metadata65.getDescription().getDescription()}", String.valueOf(metadata65.getDescription().getDescription()));
    }
}
