package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ClusteringView extends ClusteringView {

    private final Metadata metadata153;
    private final Metadata metadata152;
    private final Metadata metadata149;
    private final Metadata metadata154;
    private final Metadata metadata150;
    private final Metadata metadata151;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ClusteringView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata153Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*");
        this.metadata153 = mbuiContext.metadataRegistry().lookup(metadata153Template);
        AddressTemplate metadata152Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/socket-discovery-group=*");
        this.metadata152 = mbuiContext.metadataRegistry().lookup(metadata152Template);
        AddressTemplate metadata149Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jgroups-broadcast-group=*");
        this.metadata149 = mbuiContext.metadataRegistry().lookup(metadata149Template);
        AddressTemplate metadata154Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*");
        this.metadata154 = mbuiContext.metadataRegistry().lookup(metadata154Template);
        AddressTemplate metadata150Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/socket-broadcast-group=*");
        this.metadata150 = mbuiContext.metadataRegistry().lookup(metadata150Template);
        AddressTemplate metadata151Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jgroups-discovery-group=*");
        this.metadata151 = mbuiContext.metadataRegistry().lookup(metadata151Template);
        this.expressionElements = new HashMap<>();

        jgroupsBroadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-broadcast-group-form", metadata149)
            .include("broadcast-period", "connectors", "jgroups-cluster", "jgroups-channel", "jgroups-stack")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JGROUPS_BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JGROUPS_BROADCAST_GROUP, form))
            .build();
        socketBroadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-broadcast-group-form", metadata150)
            .include("broadcast-period", "connectors", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.SOCKET_BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.SOCKET_BROADCAST_GROUP, form))
            .build();
        socketBroadcastGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        jgroupsDiscoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-discovery-group-form", metadata151)
            .include("initial-wait-timeout", "refresh-timeout", "jgroups-cluster", "jgroups-channel", "jgroups-stack")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JGROUPS_DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JGROUPS_DISCOVERY_GROUP, form))
            .build();
        socketDiscoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-discovery-group-form", metadata152)
            .include("initial-wait-timeout", "refresh-timeout", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.SOCKET_DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.SOCKET_DISCOVERY_GROUP, form))
            .build();
        socketDiscoveryGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        clusterConnectionForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-form", metadata153)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CLUSTER_CONNECTION, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CLUSTER_CONNECTION, form))
            .build();
        groupingHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-form", metadata154)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.GROUPING_HANDLER, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.GROUPING_HANDLER, form))
            .build();

        jgroupsBroadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-broadcast-group-table", metadata149)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JGROUPS_BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JGROUPS_BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        socketBroadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-broadcast-group-table", metadata150)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.SOCKET_BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.SOCKET_BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jgroupsDiscoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-discovery-group-table", metadata151)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JGROUPS_DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JGROUPS_DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        socketDiscoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-discovery-group-table", metadata152)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.SOCKET_DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.SOCKET_DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        clusterConnectionTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-table", metadata153)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClusterConnection(ServerSubResource.CLUSTER_CONNECTION), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CLUSTER_CONNECTION, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        groupingHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-table", metadata154)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.GROUPING_HANDLER), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.GROUPING_HANDLER, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-broadcast-group-item", "Broadcast Group", "fa fa-video-camera");
        HTMLElement html444;
        HTMLElement msgJgroupsBroadcastGroupItemElement = section()
            .add(html444 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JGroups Broadcast Group</h1><p>${metadata149.getDescription().getDescription()}</p>"))
                                    .element())
            .add(jgroupsBroadcastGroupTable)
            .add(jgroupsBroadcastGroupForm)
                            .element();
        expressionElements.put("html444", html444);
        navigation.addSecondary("messaging-broadcast-group-item", "msg-jgroups-broadcast-group-item", "JGroups Broadcast Group", msgJgroupsBroadcastGroupItemElement);
        HTMLElement html447;
        HTMLElement msgSocketBroadcastGroupItemElement = section()
            .add(html447 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Broadcast Group</h1><p>${metadata150.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketBroadcastGroupTable)
            .add(socketBroadcastGroupForm)
                            .element();
        expressionElements.put("html447", html447);
        navigation.addSecondary("messaging-broadcast-group-item", "msg-socket-broadcast-group-item", "Socket Broadcast Group", msgSocketBroadcastGroupItemElement);
        navigation.addPrimary("messaging-discovery-group-item", "Discovery Group", "fa fa-map-o");
        HTMLElement html450;
        HTMLElement msgJgroupsDiscoveryGroupItemElement = section()
            .add(html450 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JGroups Discovery Group</h1><p>${metadata151.getDescription().getDescription()}</p>"))
                                    .element())
            .add(jgroupsDiscoveryGroupTable)
            .add(jgroupsDiscoveryGroupForm)
                            .element();
        expressionElements.put("html450", html450);
        navigation.addSecondary("messaging-discovery-group-item", "msg-jgroups-discovery-group-item", "JGroups Discovery Group", msgJgroupsDiscoveryGroupItemElement);
        HTMLElement html453;
        HTMLElement msgSocketDiscoveryGroupItemElement = section()
            .add(html453 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Discovery Group</h1><p>${metadata152.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketDiscoveryGroupTable)
            .add(socketDiscoveryGroupForm)
                            .element();
        expressionElements.put("html453", html453);
        navigation.addSecondary("messaging-discovery-group-item", "msg-socket-discovery-group-item", "Socket Discovery Group", msgSocketDiscoveryGroupItemElement);
        HTMLElement html456;
        HTMLElement messagingClusterConnectionItemElement = section()
            .add(html456 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cluster Connection</h1><p>${metadata153.getDescription().getDescription()}</p>"))
                            .element())
            .add(clusterConnectionTable)
            .add(clusterConnectionForm)
                    .element();
        expressionElements.put("html456", html456);
        navigation.addPrimary("messaging-cluster-connection-item", "Cluster Connection", "pficon pficon-network", messagingClusterConnectionItemElement);
        HTMLElement html459;
        HTMLElement messagingGroupingHandlerItemElement = section()
            .add(html459 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Grouping Handler</h1><p>${metadata154.getDescription().getDescription()}</p>"))
                            .element())
            .add(groupingHandlerTable)
            .add(groupingHandlerForm)
                    .element();
        expressionElements.put("html459", html459);
        navigation.addPrimary("messaging-grouping-handler-item", "Grouping Handler", "fa fa-object-group", messagingGroupingHandlerItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(jgroupsBroadcastGroupTable);
        registerAttachable(socketBroadcastGroupTable);
        registerAttachable(jgroupsBroadcastGroupForm);
        registerAttachable(socketBroadcastGroupForm);
        registerAttachable(jgroupsDiscoveryGroupTable);
        registerAttachable(socketDiscoveryGroupTable);
        registerAttachable(jgroupsDiscoveryGroupForm);
        registerAttachable(socketDiscoveryGroupForm);
        registerAttachable(clusterConnectionTable);
        registerAttachable(clusterConnectionForm);
        registerAttachable(groupingHandlerTable);
        registerAttachable(groupingHandlerForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            jgroupsBroadcastGroupTable.bindForm(jgroupsBroadcastGroupForm);
            socketBroadcastGroupTable.bindForm(socketBroadcastGroupForm);
            jgroupsDiscoveryGroupTable.bindForm(jgroupsDiscoveryGroupForm);
            socketDiscoveryGroupTable.bindForm(socketDiscoveryGroupForm);
            clusterConnectionTable.bindForm(clusterConnectionForm);
            groupingHandlerTable.bindForm(groupingHandlerForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html444"), "${metadata149.getDescription().getDescription()}", String.valueOf(metadata149.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html447"), "${metadata150.getDescription().getDescription()}", String.valueOf(metadata150.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html450"), "${metadata151.getDescription().getDescription()}", String.valueOf(metadata151.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html453"), "${metadata152.getDescription().getDescription()}", String.valueOf(metadata152.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html456"), "${metadata153.getDescription().getDescription()}", String.valueOf(metadata153.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html459"), "${metadata154.getDescription().getDescription()}", String.valueOf(metadata154.getDescription().getDescription()));
    }
}
