package org.jboss.hal.client.configuration.subsystem.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemotingView extends RemotingView {

    private final Metadata metadata144;
    private final Metadata metadata142;
    private final Metadata metadata141;
    private final Metadata metadata143;
    private final Metadata metadata140;
    private final Metadata metadata145;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemotingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata144Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/outbound-connection=*");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        AddressTemplate metadata142Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*");
        this.metadata142 = mbuiContext.metadataRegistry().lookup(metadata142Template);
        AddressTemplate metadata141Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        AddressTemplate metadata143Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/local-outbound-connection=*");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata140Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting");
        this.metadata140 = mbuiContext.metadataRegistry().lookup(metadata140Template);
        AddressTemplate metadata145Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/remote-outbound-connection=*");
        this.metadata145 = mbuiContext.metadataRegistry().lookup(metadata145Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("remoting-configuration", metadata140)
            .customGroup("remoting-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("buffer-region-size", "heartbeat-interval", "receive-buffer-size", "receive-window-size", "send-buffer-size", "server-name", "transmit-window-size", "worker")
            .end()
            .customGroup("remoting-configuration-security", "Security")
                .include("auth-realm", "authentication-retries", "authorize-id", "sasl-protocol")
            .end()
            .customGroup("remoting-configuration-channels", "Channels")
                .include("max-inbound-channels", "max-inbound-message-size", "max-inbound-messages", "max-outbound-channels", "max-outbound-message-size", "max-outbound-messages")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata140Template.resolve(statementContext()), changedValues, metadata140))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata140Template.resolve(statementContext()), form, metadata140))
            .build();
        localOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-form", metadata143)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("outbound-socket-binding-ref")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveLocalOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetLocalOutbound(form))
            .build();
        localOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
        outboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-form", metadata144)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("uri")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetOutbound(form))
            .build();
        remoteOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-form", metadata145)
            .include("authentication-context")
            .include("outbound-socket-binding-ref")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveRemoteOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetRemoteOutbound(form))
            .build();
        remoteOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-connector-table", metadata141)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-connector-table", Ids.ADD), "Connector",
                metadata141Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Connector", metadata141Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-http-connector-table", metadata142)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-http-connector-table", Ids.ADD), "HTTP Connector",
                metadata142Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("HTTP Connector", metadata142Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        localOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-table", metadata143)
            .button(mbuiContext.tableButtonFactory().add(metadata143Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-local-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Local Outbound"),
                    metadata143,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata143Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Local Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Local Outbound", metadata143Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-table", metadata144)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-outbound-table", Ids.ADD), "Outbound",
                metadata144Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Outbound", metadata144Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-table", metadata145)
            .button(mbuiContext.tableButtonFactory().add(metadata145Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-remote-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Remote Outbound"),
                    metadata145,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata145Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Remote Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Remote Outbound", metadata145Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html419;
        HTMLElement remotingConfigurationItemElement = section()
            .add(html419 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata140.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html419", html419);
        navigation.addPrimary("remoting-configuration-item", "Configuration", "pficon pficon-settings", remotingConfigurationItemElement);
        navigation.addPrimary("remoting-remote-connector-item", "Remote Connector", "pficon pficon-network");
        HTMLElement html421;
        HTMLElement remotingConnectorSubItemElement = section()
            .add(html421 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector</h1><p>${metadata141.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
                            .element();
        expressionElements.put("html421", html421);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-connector-sub-item", "Connector", remotingConnectorSubItemElement);
        HTMLElement html423;
        HTMLElement remotingHttpConnectorSubItemElement = section()
            .add(html423 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata142.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
                            .element();
        expressionElements.put("html423", html423);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-http-connector-sub-item", "HTTP Connector", remotingHttpConnectorSubItemElement);
        navigation.addPrimary("remoting-outbound-connection-item", "Outbound Connection", "pficon pficon-service");
        HTMLElement html425;
        HTMLElement remotingLocalOutboundSubItemElement = section()
            .add(html425 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Local Outbound</h1><p>${metadata143.getDescription().getDescription()}</p>"))
                                    .element())
            .add(localOutboundTable)
            .add(localOutboundForm)
                            .element();
        expressionElements.put("html425", html425);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-local-outbound-sub-item", "Local Outbound", remotingLocalOutboundSubItemElement);
        HTMLElement html428;
        HTMLElement remotingOutboundSubItemElement = section()
            .add(html428 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound</h1><p>${metadata144.getDescription().getDescription()}</p>"))
                                    .element())
            .add(outboundTable)
            .add(outboundForm)
                            .element();
        expressionElements.put("html428", html428);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-outbound-sub-item", "Outbound", remotingOutboundSubItemElement);
        HTMLElement html431;
        HTMLElement remotingRemoteOutboundSubItemElement = section()
            .add(html431 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Outbound</h1><p>${metadata145.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteOutboundTable)
            .add(remoteOutboundForm)
                            .element();
        expressionElements.put("html431", html431);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-remote-outbound-sub-item", "Remote Outbound", remotingRemoteOutboundSubItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(connectorTable);
        registerAttachable(httpConnectorTable);
        registerAttachable(localOutboundTable);
        registerAttachable(localOutboundForm);
        registerAttachable(outboundTable);
        registerAttachable(outboundForm);
        registerAttachable(remoteOutboundTable);
        registerAttachable(remoteOutboundForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            localOutboundTable.bindForm(localOutboundForm);
            outboundTable.bindForm(outboundForm);
            remoteOutboundTable.bindForm(remoteOutboundForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html419"), "${metadata140.getDescription().getDescription()}", String.valueOf(metadata140.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html421"), "${metadata141.getDescription().getDescription()}", String.valueOf(metadata141.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html423"), "${metadata142.getDescription().getDescription()}", String.valueOf(metadata142.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html425"), "${metadata143.getDescription().getDescription()}", String.valueOf(metadata143.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html428"), "${metadata144.getDescription().getDescription()}", String.valueOf(metadata144.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html431"), "${metadata145.getDescription().getDescription()}", String.valueOf(metadata145.getDescription().getDescription()));
    }
}
