package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata109;
    private final Metadata metadata110;
    private final Metadata metadata108;
    private final Metadata metadata112;
    private final Metadata metadata111;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata109Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata109 = mbuiContext.metadataRegistry().lookup(metadata109Template);
        AddressTemplate metadata110Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata110 = mbuiContext.metadataRegistry().lookup(metadata110Template);
        AddressTemplate metadata108Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata108 = mbuiContext.metadataRegistry().lookup(metadata108Template);
        AddressTemplate metadata112Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata112 = mbuiContext.metadataRegistry().lookup(metadata112Template);
        AddressTemplate metadata111Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata111 = mbuiContext.metadataRegistry().lookup(metadata111Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata108)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata108Template.resolve(statementContext()), changedValues, metadata108))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata108Template.resolve(statementContext()), form, metadata108))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata109)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata109Template.resolve(statementContext(), name), changedValues, metadata109);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata109Template.resolve(statementContext(), name), form, metadata109);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata110)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata110Template.resolve(statementContext(), name), changedValues, metadata110);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata110Template.resolve(statementContext(), name), form, metadata110);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata111)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata111Template.resolve(statementContext(), name), changedValues, metadata111);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata111Template.resolve(statementContext(), name), form, metadata111);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata112)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata112Template.resolve(statementContext(), name), changedValues, metadata112);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata112Template.resolve(statementContext(), name), form, metadata112);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata109)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata109Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata109Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata110)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "JVM",
                metadata110Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata110Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata111)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata111Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata111Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata112)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata112Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata112Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html322;
        HTMLElement serverConfigurationItemElement = section()
            .add(html322 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata108.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverConfigurationForm)
                    .element();
        expressionElements.put("html322", html322);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html324;
        HTMLElement serverInterfaceItemElement = section()
            .add(html324 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata109.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
                    .element();
        expressionElements.put("html324", html324);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html327;
        HTMLElement serverJvmItemElement = section()
            .add(html327 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata110.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverJvmTable)
            .add(serverJvmForm)
                    .element();
        expressionElements.put("html327", html327);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html330;
        HTMLElement serverPathItemElement = section()
            .add(html330 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata111.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverPathTable)
            .add(serverPathForm)
                    .element();
        expressionElements.put("html330", html330);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html333;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html333 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata112.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
                    .element();
        expressionElements.put("html333", html333);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html322"), "${metadata108.getDescription().getDescription()}", String.valueOf(metadata108.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html324"), "${metadata109.getDescription().getDescription()}", String.valueOf(metadata109.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html327"), "${metadata110.getDescription().getDescription()}", String.valueOf(metadata110.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html330"), "${metadata111.getDescription().getDescription()}", String.valueOf(metadata111.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html333"), "${metadata112.getDescription().getDescription()}", String.valueOf(metadata112.getDescription().getDescription()));
    }
}
