package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingProfileView extends LoggingProfileView {

    private final org.jboss.hal.core.CrudOperations crud;
    private final Metadata metadata63;
    private final Metadata metadata59;
    private final Metadata metadata62;
    private final Metadata metadata57;
    private final Metadata metadata56;
    private final Metadata metadata51;
    private final Metadata metadata60;
    private final Metadata metadata55;
    private final Metadata metadata53;
    private final Metadata metadata54;
    private final Metadata metadata52;
    private final Metadata metadata61;
    private final Metadata metadata58;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingProfileView(MbuiContext mbuiContext, org.jboss.hal.core.CrudOperations crud) {
        super(mbuiContext);

        this.crud = crud;
        AddressTemplate metadata63Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*");
        this.metadata63 = mbuiContext.metadataRegistry().lookup(metadata63Template);
        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        AddressTemplate metadata56Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/file-handler=*");
        this.metadata56 = mbuiContext.metadataRegistry().lookup(metadata56Template);
        AddressTemplate metadata51Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/root-logger=ROOT");
        this.metadata51 = mbuiContext.metadataRegistry().lookup(metadata51Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/socket-handler=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata55Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*");
        this.metadata55 = mbuiContext.metadataRegistry().lookup(metadata55Template);
        AddressTemplate metadata53Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/async-handler=*");
        this.metadata53 = mbuiContext.metadataRegistry().lookup(metadata53Template);
        AddressTemplate metadata54Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/console-handler=*");
        this.metadata54 = mbuiContext.metadataRegistry().lookup(metadata54Template);
        AddressTemplate metadata52Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/logger=*");
        this.metadata52 = mbuiContext.metadataRegistry().lookup(metadata52Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        this.expressionElements = new HashMap<>();

        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-profile-root-logger-form", metadata51)
            .include("filter-spec", "handlers", "level")
            .unsorted()
            .onSave((form, changedValues) -> saveRootLogger(form, changedValues))
            .prepareReset(form -> resetRootLogger(form))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-form", metadata52)
            .include("category", "filter-spec", "handlers", "level", "use-parent-handlers")
            .unsorted()
            .onSave((form, changedValues) -> saveLogger(form, changedValues))
            .prepareReset(form -> resetLogger(form))
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-form", metadata54)
            .include("autoflush", "enabled", "encoding", "filter-spec", "formatter", "level", "named-formatter", "target")
            .unsorted()
            .onSave((form, changedValues) -> saveConsoleHandler(form, changedValues))
            .prepareReset(form -> resetConsoleHandler(form))
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-form", metadata56)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "named-formatter")
            .unsorted()
            .onSave((form, changedValues) -> saveFileHandler(form, changedValues))
            .prepareReset(form -> resetFileHandler(form))
            .build();
        fileHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-form", metadata57)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "named-formatter", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicHandler(form))
            .build();
        periodicHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-form", metadata58)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "max-backup-index", "named-formatter", "rotate-size", "rotate-on-boot", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicSizeHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicSizeHandler(form))
            .build();
        periodicSizeHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-form", metadata59)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "max-backup-index", "named-formatter", "rotate-size", "rotate-on-boot", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> saveSizeHandler(form, changedValues))
            .prepareReset(form -> resetSizeHandler(form))
            .build();
        sizeHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-form", metadata53)
            .include("filter-spec", "level", "overflow-action", "queue-length", "subhandlers")
            .unsorted()
            .onSave((form, changedValues) -> saveAsyncHandler(form, changedValues))
            .prepareReset(form -> resetAsyncHandler(form))
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-form", metadata55)
            .include("enabled", "encoding", "class", "filter-spec", "formatter", "level", "module", "named-formatter", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomHandler(form, changedValues))
            .prepareReset(form -> resetCustomHandler(form))
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), customHandlerFormTemplates));
        socketHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-socket-form", metadata60)
            .include("autoflush", "block-on-reconnect", "enabled", "encoding", "filter-spec", "level", "named-formatter", "outbound-socket-binding-ref", "protocol", "ssl-context")
            .unsorted()
            .onSave((form, changedValues) -> saveSocketHandler(form, changedValues))
            .prepareReset(form -> resetSocketHandler(form))
            .build();
        List<AddressTemplate> socketHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        socketHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), socketHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-form", metadata61)
            .include("app-name", "enabled", "facility", "hostname", "level", "named-formatter", "port", "server-address", "syslog-format")
            .unsorted()
            .onSave((form, changedValues) -> saveSyslogHandler(form, changedValues))
            .prepareReset(form -> resetSyslogHandler(form))
            .build();
        List<AddressTemplate> syslogHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/xml-formatter=*"));
        syslogHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), syslogHandlerFormTemplates));
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-form", metadata62)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomFormatter(form, changedValues))
            .prepareReset(form -> resetCustomFormatter(form))
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-form", metadata63)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> savePatternFormatter(form, changedValues))
            .prepareReset(form -> resetPatternFormatter(form))
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-table", metadata52)
            .button(mbuiContext.resources().constants().add(), table -> addLogger(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeLogger(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:remove)"))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-table", metadata54)
            .button(mbuiContext.resources().constants().add(), table -> addConsoleHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeConsoleHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:remove)"))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-table", metadata56)
            .button(mbuiContext.resources().constants().add(), table -> addFileHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeFileHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-table", metadata57)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-table", metadata58)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-table", metadata59)
            .button(mbuiContext.resources().constants().add(), table -> addSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-table", metadata53)
            .button(mbuiContext.resources().constants().add(), table -> addAsyncHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeAsyncHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:remove)"))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-table", metadata55)
            .button(mbuiContext.resources().constants().add(), table -> addCustomHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:remove)"))
            .columns("name", "level")
            .build();
        socketHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-socket-table", metadata60)
            .button(mbuiContext.resources().constants().add(), table -> addSocketHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/socket-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSocketHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/socket-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-table", metadata61)
            .button(mbuiContext.resources().constants().add(), table -> addSyslogHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSyslogHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-table", metadata62)
            .button(mbuiContext.resources().constants().add(), table -> addCustomFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-table", metadata63)
            .button(mbuiContext.resources().constants().add(), table -> addPatternFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePatternFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html145;
        HTMLElement loggingProfileRootLoggerItemElement = section()
            .add(html145 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-profile-root-logger-header\">Root Logger</h1><p id=\"logging-profile-root-logger-description\">${metadata51.getDescription().getDescription()}</p>"))
                            .element())
            .add(rootLoggerForm)
                    .element();
        expressionElements.put("html145", html145);
        navigation.addPrimary("logging-profile-root-logger-item", "Root Logger", "fa fa-sitemap", loggingProfileRootLoggerItemElement);
        HTMLElement html147;
        HTMLElement loggingProfileCategoryItemElement = section()
            .add(html147 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata52.getDescription().getDescription()}</p>"))
                            .element())
            .add(loggerTable)
            .add(loggerForm)
                    .element();
        expressionElements.put("html147", html147);
        navigation.addPrimary("logging-profile-category-item", "Categories", "pficon pficon-repository", loggingProfileCategoryItemElement);
        navigation.addPrimary("logging-profile-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html150;
        HTMLElement loggingProfileHandlerAsyncItemElement = section()
            .add(html150 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata53.getDescription().getDescription()}</p>"))
                                    .element())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
                            .element();
        expressionElements.put("html150", html150);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-async-item", "Async Handler", loggingProfileHandlerAsyncItemElement);
        HTMLElement html153;
        HTMLElement loggingProfileHandlerConsoleItemElement = section()
            .add(html153 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata54.getDescription().getDescription()}</p>"))
                                    .element())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
                            .element();
        expressionElements.put("html153", html153);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-console-item", "Console Handler", loggingProfileHandlerConsoleItemElement);
        HTMLElement html156;
        HTMLElement loggingProfileHandlerCustomItemElement = section()
            .add(html156 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata55.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customHandlerTable)
            .add(customHandlerForm)
                            .element();
        expressionElements.put("html156", html156);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-custom-item", "Custom Handler", loggingProfileHandlerCustomItemElement);
        HTMLElement html159;
        HTMLElement loggingProfileHandlerFileItemElement = section()
            .add(html159 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata56.getDescription().getDescription()}</p>"))
                                    .element())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
                            .element();
        expressionElements.put("html159", html159);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-file-item", "File Handler", loggingProfileHandlerFileItemElement);
        HTMLElement html162;
        HTMLElement loggingProfileHandlerPeriodicRotatingFileItemElement = section()
            .add(html162 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata57.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
                            .element();
        expressionElements.put("html162", html162);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-rotating-file-item", "Periodic Handler", loggingProfileHandlerPeriodicRotatingFileItemElement);
        HTMLElement html165;
        HTMLElement loggingProfileHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html165 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata58.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
                            .element();
        expressionElements.put("html165", html165);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingProfileHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html168;
        HTMLElement loggingProfileHandlerSizeRotatingFileItemElement = section()
            .add(html168 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata59.getDescription().getDescription()}</p>"))
                                    .element())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
                            .element();
        expressionElements.put("html168", html168);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-size-rotating-file-item", "Size Handler", loggingProfileHandlerSizeRotatingFileItemElement);
        HTMLElement html171;
        HTMLElement loggingProfileHandlerSocketItemElement = section()
            .add(html171 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Handler</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketHandlerTable)
            .add(socketHandlerForm)
                            .element();
        expressionElements.put("html171", html171);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-socket-item", "Socket Handler", loggingProfileHandlerSocketItemElement);
        HTMLElement html174;
        HTMLElement loggingProfileHandlerSyslogItemElement = section()
            .add(html174 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata61.getDescription().getDescription()}</p>"))
                                    .element())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
                            .element();
        expressionElements.put("html174", html174);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-syslog-item", "Syslog Handler", loggingProfileHandlerSyslogItemElement);
        navigation.addPrimary("logging-profile-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html177;
        HTMLElement loggingProfileFormatterCustomItemElement = section()
            .add(html177 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata62.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customFormatterTable)
            .add(customFormatterForm)
                            .element();
        expressionElements.put("html177", html177);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-custom-item", "Custom Formatter", loggingProfileFormatterCustomItemElement);
        HTMLElement html180;
        HTMLElement loggingProfileFormatterPatternItemElement = section()
            .add(html180 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata63.getDescription().getDescription()}</p>"))
                                    .element())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
                            .element();
        expressionElements.put("html180", html180);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-pattern-item", "Pattern Formatter", loggingProfileFormatterPatternItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(socketHandlerTable);
        registerAttachable(socketHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.core.CrudOperations crud() {
    return crud;
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            socketHandlerTable.bindForm(socketHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html145"), "${metadata51.getDescription().getDescription()}", String.valueOf(metadata51.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html147"), "${metadata52.getDescription().getDescription()}", String.valueOf(metadata52.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html150"), "${metadata53.getDescription().getDescription()}", String.valueOf(metadata53.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html153"), "${metadata54.getDescription().getDescription()}", String.valueOf(metadata54.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html156"), "${metadata55.getDescription().getDescription()}", String.valueOf(metadata55.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html159"), "${metadata56.getDescription().getDescription()}", String.valueOf(metadata56.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html162"), "${metadata57.getDescription().getDescription()}", String.valueOf(metadata57.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html165"), "${metadata58.getDescription().getDescription()}", String.valueOf(metadata58.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html168"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html171"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html174"), "${metadata61.getDescription().getDescription()}", String.valueOf(metadata61.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html177"), "${metadata62.getDescription().getDescription()}", String.valueOf(metadata62.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html180"), "${metadata63.getDescription().getDescription()}", String.valueOf(metadata63.getDescription().getDescription()));
    }
}
