package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_FilterView extends FilterView {

    private final Metadata metadata143;
    private final Metadata metadata142;
    private final Metadata metadata145;
    private final Metadata metadata141;
    private final Metadata metadata147;
    private final Metadata metadata144;
    private final Metadata metadata148;
    private final Metadata metadata146;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_FilterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata143Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/expression-filter=*");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata142Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/error-page=*");
        this.metadata142 = mbuiContext.metadataRegistry().lookup(metadata142Template);
        AddressTemplate metadata145Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/mod-cluster=*");
        this.metadata145 = mbuiContext.metadataRegistry().lookup(metadata145Template);
        AddressTemplate metadata141Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/custom-filter=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        AddressTemplate metadata147Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/response-header=*");
        this.metadata147 = mbuiContext.metadataRegistry().lookup(metadata147Template);
        AddressTemplate metadata144Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/gzip=*");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        AddressTemplate metadata148Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/rewrite=*");
        this.metadata148 = mbuiContext.metadataRegistry().lookup(metadata148Template);
        AddressTemplate metadata146Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/request-limit=*");
        this.metadata146 = mbuiContext.metadataRegistry().lookup(metadata146Template);
        this.expressionElements = new HashMap<>();

        customFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-form", metadata141)
            .include("class-name")
            .include("module")
            .include("parameters")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 3)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Filter", name, metadata141Template.resolve(statementContext(), name), changedValues, metadata141);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Filter", name, metadata141Template.resolve(statementContext(), name), form, metadata141);
            })
            .build();
        errorPageForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-form", metadata142)
            .include("code")
            .include("path")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Error Page", name, metadata142Template.resolve(statementContext(), name), changedValues, metadata142);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Error Page", name, metadata142Template.resolve(statementContext(), name), form, metadata142);
            })
            .build();
        expressionFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-form", metadata143)
            .include("expression")
            .include("module")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Expression Filter", name, metadata143Template.resolve(statementContext(), name), changedValues, metadata143);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Expression Filter", name, metadata143Template.resolve(statementContext(), name), form, metadata143);
            })
            .build();
        gzipForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-form", metadata144)
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 0)
            .unsorted()
            .onSave((form, changedValues) -> noop())
            .build();
        modClusterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-form", metadata145)
            .include("advertise-frequency")
            .include("advertise-path")
            .include("advertise-protocol")
            .include("advertise-socket-binding")
            .include("broken-node-timeout")
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("enable-http2")
            .include("health-check-interval")
            .include("http2-enable-push")
            .include("http2-header-table-size")
            .include("http2-initial-window-size")
            .include("http2-max-concurrent-streams")
            .include("http2-max-frame-size")
            .include("http2-max-header-list-size")
            .include("management-access-predicate")
            .include("management-socket-binding")
            .include("max-ajp-packet-size")
            .include("max-request-time")
            .include("max-retries")
            .include("request-queue-size")
            .include("security-key")
            .include("ssl-context")
            .include("use-alias")
            .include("worker")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 26)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Mod Cluster", name, metadata145Template.resolve(statementContext(), name), changedValues, metadata145);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Mod Cluster", name, metadata145Template.resolve(statementContext(), name), form, metadata145);
            })
            .build();
        requestLimitForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-form", metadata146)
            .include("max-concurrent-requests")
            .include("queue-size")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Request Limit", name, metadata146Template.resolve(statementContext(), name), changedValues, metadata146);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Request Limit", name, metadata146Template.resolve(statementContext(), name), form, metadata146);
            })
            .build();
        responseHeaderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-form", metadata147)
            .include("header-name")
            .include("header-value")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveResponseHeader(form, changedValues))
            .prepareReset(form -> presenter.resetResponseHeader(form))
            .build();
        rewriteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-form", metadata148)
            .include("redirect")
            .include("target")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Rewrite", name, metadata148Template.resolve(statementContext(), name), changedValues, metadata148);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Rewrite", name, metadata148Template.resolve(statementContext(), name), form, metadata148);
            })
            .build();

        customFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-table", metadata141)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-custom-filter-table", Ids.ADD), "Custom Filter",
                metadata141Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Filter", metadata141Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        errorPageTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-table", metadata142)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-error-page-table", Ids.ADD), "Error Page",
                metadata142Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Error Page", metadata142Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("code")
            .build();
        expressionFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-table", metadata143)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-expression-filter-table", Ids.ADD), "Expression Filter",
                metadata143Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Expression Filter", metadata143Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("expression")
            .build();
        gzipTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-table", metadata144)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-gzip-table", Ids.ADD), "GZip",
                metadata144Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("GZip", metadata144Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        modClusterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-table", metadata145)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-mod-cluster-table", Ids.ADD), "Mod Cluster",
                metadata145Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Mod Cluster", metadata145Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("management-socket-binding")
            .build();
        requestLimitTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-table", metadata146)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-request-limit-table", Ids.ADD), "Request Limit",
                metadata146Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Request Limit", metadata146Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("max-concurrent-requests")
            .build();
        responseHeaderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-table", metadata147)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addResponseHeader(), Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeResponseHeader(table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.get("header-name").asString())
            .column("value", (cell, type, row, meta) -> row.get("header-value").asString())
            .build();
        rewriteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-table", metadata148)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-rewrite-table", Ids.ADD), "Rewrite",
                metadata148Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Rewrite", metadata148Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("target")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html422;
        HTMLElement undertowCustomFilterItemElement = section()
            .add(html422 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Filter</h1><p>${metadata141.getDescription().getDescription()}</p>"))
                            .element())
            .add(customFilterTable)
            .add(customFilterForm)
                    .element();
        expressionElements.put("html422", html422);
        navigation.addPrimary("undertow-custom-filter-item", "Custom Filter", "fa fa-file-o", undertowCustomFilterItemElement);
        HTMLElement html425;
        HTMLElement undertowErrorPageItemElement = section()
            .add(html425 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Error Page</h1><p>${metadata142.getDescription().getDescription()}</p>"))
                            .element())
            .add(errorPageTable)
            .add(errorPageForm)
                    .element();
        expressionElements.put("html425", html425);
        navigation.addPrimary("undertow-error-page-item", "Error Page", "fa fa-bug", undertowErrorPageItemElement);
        HTMLElement html428;
        HTMLElement undertowExpressionFilterItemElement = section()
            .add(html428 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Expression Filter</h1><p>${metadata143.getDescription().getDescription()}</p>"))
                            .element())
            .add(expressionFilterTable)
            .add(expressionFilterForm)
                    .element();
        expressionElements.put("html428", html428);
        navigation.addPrimary("undertow-expression-filter-item", "Expression Filter", "fa fa-terminal", undertowExpressionFilterItemElement);
        HTMLElement html431;
        HTMLElement undertowGzipItemElement = section()
            .add(html431 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>GZip</h1><p>${metadata144.getDescription().getDescription()}</p>"))
                            .element())
            .add(gzipTable)
            .add(gzipForm)
                    .element();
        expressionElements.put("html431", html431);
        navigation.addPrimary("undertow-gzip-item", "GZip", "fa fa-archive", undertowGzipItemElement);
        HTMLElement html434;
        HTMLElement undertowModClusterItemElement = section()
            .add(html434 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mod Cluster</h1><p>${metadata145.getDescription().getDescription()}</p>"))
                            .element())
            .add(modClusterTable)
            .add(modClusterForm)
                    .element();
        expressionElements.put("html434", html434);
        navigation.addPrimary("undertow-mod-cluster-item", "Mod Cluster Filter", "pficon pficon-cluster", undertowModClusterItemElement);
        HTMLElement html437;
        HTMLElement undertowRequestLimitItemElement = section()
            .add(html437 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Request Limit</h1><p>${metadata146.getDescription().getDescription()}</p>"))
                            .element())
            .add(requestLimitTable)
            .add(requestLimitForm)
                    .element();
        expressionElements.put("html437", html437);
        navigation.addPrimary("undertow-request-limit-item", "Request Limit", "fa fa-ban", undertowRequestLimitItemElement);
        HTMLElement html440;
        HTMLElement undertowResponseHeaderItemElement = section()
            .add(html440 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Response Header</h1><p>${metadata147.getDescription().getDescription()}</p>"))
                            .element())
            .add(responseHeaderTable)
            .add(responseHeaderForm)
                    .element();
        expressionElements.put("html440", html440);
        navigation.addPrimary("undertow-response-header-item", "Response Header", "fa fa-exchange", undertowResponseHeaderItemElement);
        HTMLElement html443;
        HTMLElement undertowRewriteItemElement = section()
            .add(html443 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Rewrite</h1><p>${metadata148.getDescription().getDescription()}</p>"))
                            .element())
            .add(rewriteTable)
            .add(rewriteForm)
                    .element();
        expressionElements.put("html443", html443);
        navigation.addPrimary("undertow-rewrite-item", "Rewrite", "fa fa-refresh", undertowRewriteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(customFilterTable);
        registerAttachable(customFilterForm);
        registerAttachable(errorPageTable);
        registerAttachable(errorPageForm);
        registerAttachable(expressionFilterTable);
        registerAttachable(expressionFilterForm);
        registerAttachable(gzipTable);
        registerAttachable(gzipForm);
        registerAttachable(modClusterTable);
        registerAttachable(modClusterForm);
        registerAttachable(requestLimitTable);
        registerAttachable(requestLimitForm);
        registerAttachable(responseHeaderTable);
        registerAttachable(responseHeaderForm);
        registerAttachable(rewriteTable);
        registerAttachable(rewriteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            customFilterTable.bindForm(customFilterForm);
            errorPageTable.bindForm(errorPageForm);
            expressionFilterTable.bindForm(expressionFilterForm);
            modClusterTable.bindForm(modClusterForm);
            requestLimitTable.bindForm(requestLimitForm);
            responseHeaderTable.bindForm(responseHeaderForm);
            rewriteTable.bindForm(rewriteForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html422"), "${metadata141.getDescription().getDescription()}", String.valueOf(metadata141.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html425"), "${metadata142.getDescription().getDescription()}", String.valueOf(metadata142.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html428"), "${metadata143.getDescription().getDescription()}", String.valueOf(metadata143.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html431"), "${metadata144.getDescription().getDescription()}", String.valueOf(metadata144.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html434"), "${metadata145.getDescription().getDescription()}", String.valueOf(metadata145.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html437"), "${metadata146.getDescription().getDescription()}", String.valueOf(metadata146.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html440"), "${metadata147.getDescription().getDescription()}", String.valueOf(metadata147.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html443"), "${metadata148.getDescription().getDescription()}", String.valueOf(metadata148.getDescription().getDescription()));
    }
}
