package org.jboss.hal.client.configuration.subsystem.resourceadapter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ResourceAdapterView extends ResourceAdapterView {

    private final Metadata metadata123;
    private final Metadata metadata122;
    private final Metadata metadata121;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ResourceAdapterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.profile}/subsystem=resource-adapters/resource-adapter=*/admin-objects=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.profile}/subsystem=resource-adapters/resource-adapter=*/connection-definitions=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.profile}/subsystem=resource-adapters/resource-adapter=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("resource-adapter-configuration-form", metadata121)
            .customGroup("resource-adapter-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("archive")
                .include("beanvalidationgroups")
                .include("bootstrap-context")
                .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("config-properties"), 3)
                .include("module")
                .include("statistics-enabled")
                .include("transaction-support")
            .end()
            .customGroup("resource-adapter-configuration-wm-security", "Work Manager Security")
                .include("wm-elytron-enabled")
                .include("wm-security")
                .include("wm-security-default-groups")
                .include("wm-security-default-principal")
                .include("wm-security-domain")
                .unboundFormItem(new MappingsItem("wm-security-mapping-groups", mbuiContext.resources().messages()), 5)
                .include("wm-security-mapping-required")
                .unboundFormItem(new MappingsItem("wm-security-mapping-users", mbuiContext.resources().messages()), 7)
            .end()
            .onSave((form, changedValues) -> saveConfiguration(form, changedValues))
            .prepareReset(form -> resetConfiguration(form))
            .build();
        connectionDefinitionsForm = new GroupedForm.Builder<org.jboss.hal.dmr.NamedNode>("resource-adapter-connection-definition-form", metadata122)
            .customGroup("resource-adapter-connection-definition-attributes", mbuiContext.resources().constants().attributes())
                .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("config-properties"), 0)
                .exclude("recovery-password", "recovery-elytron-enabled", "elytron-enabled", "pool-use-strict-min", "recovery-plugin-properties", "capacity-incrementer-properties", "security-domain-and-application", "use-fast-fail", "capacity-incrementer-class", "pool-prefill", "authentication-context", "authentication-context-and-application", "min-pool-size", "initial-pool-size", "capacity-decrementer-class", "recovery-plugin-class-name", "flush-strategy", "no-recovery", "validate-on-match", "background-validation", "capacity-decrementer-properties", "security-domain", "max-pool-size", "background-validation-millis", "security-application", "recovery-authentication-context", "recovery-security-domain", "recovery-username")
            .end()
            .customGroup("resource-adapter-connection-definition-pool", "Pool")
                .include("min-pool-size", "max-pool-size", "initial-pool-size", "pool-prefill", "pool-use-strict-min", "flush-strategy", "use-fast-fail", "capacity-decrementer-class", "capacity-decrementer-properties", "capacity-incrementer-class", "capacity-incrementer-properties")
            .end()
            .customGroup("resource-adapter-connection-definition-security", "Security")
                .include("elytron-enabled", "authentication-context", "authentication-context-and-application", "security-application", "security-domain", "security-domain-and-application")
            .end()
            .customGroup("resource-adapter-connection-definition-recovery", mbuiContext.resources().constants().recovery())
                .include("no-recovery", "recovery-username", "recovery-password", "recovery-elytron-enabled", "recovery-authentication-context", "recovery-security-domain", "recovery-plugin-class-name", "recovery-plugin-properties")
            .end()
            .customGroup("resource-adapter-connection-definition-validation", mbuiContext.resources().constants().validation())
                .include("background-validation", "background-validation-millis", "validate-on-match")
            .end()
            .onSave((form, changedValues) -> saveConnectionDefinition(form, changedValues))
            .prepareReset(form -> resetConnectionDefinition(form))
            .build();
        adminObjectsForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("resource-adapter-admin-object-form", metadata123)
            .include("class-name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("config-properties"), 1)
            .include("enabled")
            .include("jndi-name")
            .include("use-java-context")
            .unsorted()
            .onSave((form, changedValues) -> saveAdminObject(form, changedValues))
            .prepareReset(form -> resetAdminObject(form))
            .build();

        connectionDefinitionsTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("resource-adapter-connection-definition-table", metadata122)
            .button(mbuiContext.resources().constants().add(), table -> addConnectionDefinition(), Constraint.parse("executable({selected.profile}/subsystem=resource-adapters/resource-adapter=*/connection-definitions=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeConnectionDefinition(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=resource-adapters/resource-adapter=*/connection-definitions=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        adminObjectsTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("resource-adapter-admin-object-table", metadata123)
            .button(mbuiContext.resources().constants().add(), table -> addAdminObject(), Constraint.parse("executable({selected.profile}/subsystem=resource-adapters/resource-adapter=*/admin-objects=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeAdminObject(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=resource-adapters/resource-adapter=*/admin-objects=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html355;
        HTMLElement resourceAdapterConfigurationItemElement = section()
            .add(html355 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata121.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html355", html355);
        navigation.addPrimary("resource-adapter-configuration-item", "Configuration", "pficon pficon-settings", resourceAdapterConfigurationItemElement);
        HTMLElement html357;
        HTMLElement resourceAdapterConnectionDefinitionItemElement = section()
            .add(html357 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Definitions</h1><p>${metadata122.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionDefinitionsTable)
            .add(connectionDefinitionsForm)
                    .element();
        expressionElements.put("html357", html357);
        navigation.addPrimary("resource-adapter-connection-definition-item", "Connection Definitions", "pficon pficon-service", resourceAdapterConnectionDefinitionItemElement);
        HTMLElement html360;
        HTMLElement resourceAdapterAdminObjectItemElement = section()
            .add(html360 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Admin Objects</h1><p>${metadata123.getDescription().getDescription()}</p>"))
                            .element())
            .add(adminObjectsTable)
            .add(adminObjectsForm)
                    .element();
        expressionElements.put("html360", html360);
        navigation.addPrimary("resource-adapter-admin-object-item", "Admin Objects", "fa fa-lock", resourceAdapterAdminObjectItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(connectionDefinitionsTable);
        registerAttachable(connectionDefinitionsForm);
        registerAttachable(adminObjectsTable);
        registerAttachable(adminObjectsForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            connectionDefinitionsTable.bindForm(connectionDefinitionsForm);
            adminObjectsTable.bindForm(adminObjectsForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html355"), "${metadata121.getDescription().getDescription()}", String.valueOf(metadata121.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html357"), "${metadata122.getDescription().getDescription()}", String.valueOf(metadata122.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html360"), "${metadata123.getDescription().getDescription()}", String.valueOf(metadata123.getDescription().getDescription()));
    }
}
