package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HostView extends HostView {

    private final Metadata metadata155;
    private final Metadata metadata159;
    private final Metadata metadata157;
    private final Metadata metadata158;
    private final Metadata metadata156;
    private final Metadata metadata160;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata155Template = AddressTemplate.of("/{selected.host}");
        this.metadata155 = mbuiContext.metadataRegistry().lookup(metadata155Template);
        AddressTemplate metadata159Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata159 = mbuiContext.metadataRegistry().lookup(metadata159Template);
        AddressTemplate metadata157Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata157 = mbuiContext.metadataRegistry().lookup(metadata157Template);
        AddressTemplate metadata158Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata158 = mbuiContext.metadataRegistry().lookup(metadata158Template);
        AddressTemplate metadata156Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata156 = mbuiContext.metadataRegistry().lookup(metadata156Template);
        AddressTemplate metadata160Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata160 = mbuiContext.metadataRegistry().lookup(metadata160Template);
        this.expressionElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata155)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata155Template.resolve(statementContext()), form, metadata155))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata156)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata156Template.resolve(statementContext(), name), changedValues, metadata156);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata156Template.resolve(statementContext(), name), form, metadata156);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata157)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata157Template.resolve(statementContext(), name), changedValues, metadata157);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata157Template.resolve(statementContext(), name), form, metadata157);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata158)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata158Template.resolve(statementContext(), name), changedValues, metadata158);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata158Template.resolve(statementContext(), name), form, metadata158);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata159)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata159Template.resolve(statementContext(), name), changedValues, metadata159);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata159Template.resolve(statementContext(), name), form, metadata159);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata160)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata160Template.resolve(statementContext(), name), changedValues, metadata160);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata160Template.resolve(statementContext(), name), form, metadata160);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata156)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD), "Interface",
                metadata156Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata156Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata157)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD), "JVM",
                metadata157Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata157Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata158)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD), "Path",
                metadata158Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata158Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata159)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD), "Socket Binding Group",
                metadata159Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata159Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata160)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD), "System Property",
                metadata160Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata160Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html465;
        HTMLElement hostConfigurationItemElement = section()
            .add(html465 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>${metadata155.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostConfigurationForm)
                    .element();
        expressionElements.put("html465", html465);
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        HTMLElement html467;
        HTMLElement hostInterfaceItemElement = section()
            .add(html467 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata156.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostInterfaceTable)
            .add(hostInterfaceForm)
                    .element();
        expressionElements.put("html467", html467);
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        HTMLElement html470;
        HTMLElement hostJvmItemElement = section()
            .add(html470 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata157.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostJvmTable)
            .add(hostJvmForm)
                    .element();
        expressionElements.put("html470", html470);
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        HTMLElement html473;
        HTMLElement hostPathItemElement = section()
            .add(html473 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata158.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostPathTable)
            .add(hostPathForm)
                    .element();
        expressionElements.put("html473", html473);
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        HTMLElement html476;
        HTMLElement hostSocketBindingGroupItemElement = section()
            .add(html476 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>${metadata159.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSocketBindingGroupTable)
            .add(hostSocketBindingGroupForm)
                    .element();
        expressionElements.put("html476", html476);
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        HTMLElement html479;
        HTMLElement hostSystemPropertyItemElement = section()
            .add(html479 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata160.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSystemPropertyTable)
            .add(hostSystemPropertyForm)
                    .element();
        expressionElements.put("html479", html479);
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html465"), "${metadata155.getDescription().getDescription()}", String.valueOf(metadata155.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html467"), "${metadata156.getDescription().getDescription()}", String.valueOf(metadata156.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html470"), "${metadata157.getDescription().getDescription()}", String.valueOf(metadata157.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html473"), "${metadata158.getDescription().getDescription()}", String.valueOf(metadata158.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html476"), "${metadata159.getDescription().getDescription()}", String.valueOf(metadata159.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html479"), "${metadata160.getDescription().getDescription()}", String.valueOf(metadata160.getDescription().getDescription()));
    }
}
