package org.jboss.hal.client.configuration.subsystem.coremanagement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_CoreManagementView extends CoreManagementView {

    private final Metadata metadata10;
    private final Metadata metadata11;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_CoreManagementView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/service=configuration-changes");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/process-state-listener=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        this.expressionElements = new HashMap<>();

        confChangesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("core-mgmt-conf-change-form", metadata10)
            .singleton(
                () -> new Operation.Builder(metadata10Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> presenter.addConfigurationChanges())
            .prepareRemove(form -> removeSingletonForm("Configuration Changes", metadata10Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Configuration Changes", metadata10Template.resolve(statementContext()), changedValues, metadata10))
            .prepareReset(form -> resetSingletonForm("Configuration Changes", metadata10Template.resolve(statementContext()), form, metadata10))
            .build();
        prcStateListenerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-form", metadata11)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Process State Listeners", name, metadata11Template.resolve(statementContext(), name), changedValues, metadata11);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Process State Listeners", name, metadata11Template.resolve(statementContext(), name), form, metadata11);
            })
            .build();

        prcStateListenerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-table", metadata11)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("core-mgmt-prc-state-table", Ids.ADD), "Process State Listeners",
                metadata11Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Process State Listeners", metadata11Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html29;
        HTMLElement coreMgmtConfChangeItemElement = section()
            .add(html29 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration Changes</h1><p>${metadata10.getDescription().getDescription()}</p>"))
                            .element())
            .add(confChangesForm)
                    .element();
        expressionElements.put("html29", html29);
        navigation.addPrimary("core-mgmt-conf-change-item", "Configuration Changes", "pficon pficon-settings", coreMgmtConfChangeItemElement);
        HTMLElement html31;
        HTMLElement coreMgmtPrcStateItemElement = section()
            .add(html31 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process State Listeners</h1><p>${metadata11.getDescription().getDescription()}</p>"))
                            .element())
            .add(prcStateListenerTable)
            .add(prcStateListenerForm)
                    .element();
        expressionElements.put("html31", html31);
        navigation.addPrimary("core-mgmt-prc-state-item", "Process State Listeners", "pficon pficon-memory", coreMgmtPrcStateItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(confChangesForm);
        registerAttachable(prcStateListenerTable);
        registerAttachable(prcStateListenerForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        ExpressionUtil.replaceExpression(expressionElements.get("html29"), "${metadata10.getDescription().getDescription()}", String.valueOf(metadata10.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html31"), "${metadata11.getDescription().getDescription()}", String.valueOf(metadata11.getDescription().getDescription()));
    }
}
