package org.jboss.hal.client.configuration.subsystem.distributableweb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DistributableWebView extends DistributableWebView {

    private final Metadata metadata13;
    private final Metadata metadata14;
    private final Metadata metadata15;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DistributableWebView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/hotrod-single-sign-on-management=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/infinispan-single-sign-on-management=*");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("dw-configuration-form", metadata13)
            .onSave((form, changedValues) -> saveSingletonForm("Distributable Web", metadata13Template.resolve(statementContext()), changedValues, metadata13))
            .prepareReset(form -> resetSingletonForm("Distributable Web", metadata13Template.resolve(statementContext()), form, metadata13))
            .build();
        hotRodSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-form", metadata14)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Hotrod Single Sign On Management", name, metadata14Template.resolve(statementContext(), name), changedValues, metadata14);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Hotrod Single Sign On Management", name, metadata14Template.resolve(statementContext(), name), form, metadata14);
            })
            .build();
        infinispanSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-form", metadata15)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Infinispan Single Sign On Management", name, metadata15Template.resolve(statementContext(), name), changedValues, metadata15);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Infinispan Single Sign On Management", name, metadata15Template.resolve(statementContext(), name), form, metadata15);
            })
            .build();

        hotRodSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-table", metadata14)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-hotrod-sso-management-table", Ids.ADD), "Hotrod Single Sign On Management",
                metadata14Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Hotrod Single Sign On Management", metadata14Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        infinispanSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-table", metadata15)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-infinispan-sso-management-table", Ids.ADD), "Infinispan Single Sign On Management",
                metadata15Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Infinispan Single Sign On Management", metadata15Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html37;
        HTMLElement dwConfigurationItemElement = section()
            .add(html37 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Distributable Web</h1><p>${metadata13.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html37", html37);
        navigation.addPrimary("dw-configuration-item", "Configuration", "pficon pficon-settings", dwConfigurationItemElement);
        HTMLElement html39;
        HTMLElement dwHotrodSsoManagementItemElement = section()
            .add(html39 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HotRod SSO Management</h1><p>${metadata14.getDescription().getDescription()}</p>"))
                            .element())
            .add(hotRodSSOManagementTable)
            .add(hotRodSSOManagementForm)
                    .element();
        expressionElements.put("html39", html39);
        navigation.addPrimary("dw-hotrod-sso-management-item", "HotRod SSO", "fa fa-lock", dwHotrodSsoManagementItemElement);
        HTMLElement html42;
        HTMLElement dwInfinispanSsoManagementItemElement = section()
            .add(html42 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Infinispan SSO Management</h1><p>${metadata15.getDescription().getDescription()}</p>"))
                            .element())
            .add(infinispanSSOManagementTable)
            .add(infinispanSSOManagementForm)
                    .element();
        expressionElements.put("html42", html42);
        navigation.addPrimary("dw-infinispan-sso-management-item", "Infinispan SSO", "fa fa-lock", dwInfinispanSsoManagementItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(hotRodSSOManagementTable);
        registerAttachable(hotRodSSOManagementForm);
        registerAttachable(infinispanSSOManagementTable);
        registerAttachable(infinispanSSOManagementForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hotRodSSOManagementTable.bindForm(hotRodSSOManagementForm);
            infinispanSSOManagementTable.bindForm(infinispanSSOManagementForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html37"), "${metadata13.getDescription().getDescription()}", String.valueOf(metadata13.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html39"), "${metadata14.getDescription().getDescription()}", String.valueOf(metadata14.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html42"), "${metadata15.getDescription().getDescription()}", String.valueOf(metadata15.getDescription().getDescription()));
    }
}
