package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ClusteringView extends ClusteringView {

    private final Metadata metadata82;
    private final Metadata metadata81;
    private final Metadata metadata78;
    private final Metadata metadata83;
    private final Metadata metadata79;
    private final Metadata metadata80;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ClusteringView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata82Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*");
        this.metadata82 = mbuiContext.metadataRegistry().lookup(metadata82Template);
        AddressTemplate metadata81Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/socket-discovery-group=*");
        this.metadata81 = mbuiContext.metadataRegistry().lookup(metadata81Template);
        AddressTemplate metadata78Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jgroups-broadcast-group=*");
        this.metadata78 = mbuiContext.metadataRegistry().lookup(metadata78Template);
        AddressTemplate metadata83Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*");
        this.metadata83 = mbuiContext.metadataRegistry().lookup(metadata83Template);
        AddressTemplate metadata79Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/socket-broadcast-group=*");
        this.metadata79 = mbuiContext.metadataRegistry().lookup(metadata79Template);
        AddressTemplate metadata80Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jgroups-discovery-group=*");
        this.metadata80 = mbuiContext.metadataRegistry().lookup(metadata80Template);
        this.expressionElements = new HashMap<>();

        jgroupsBroadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-broadcast-group-form", metadata78)
            .include("broadcast-period", "connectors", "jgroups-cluster", "jgroups-channel", "jgroups-stack")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JGROUPS_BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JGROUPS_BROADCAST_GROUP, form))
            .build();
        socketBroadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-broadcast-group-form", metadata79)
            .include("broadcast-period", "connectors", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.SOCKET_BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.SOCKET_BROADCAST_GROUP, form))
            .build();
        socketBroadcastGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        jgroupsDiscoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-discovery-group-form", metadata80)
            .include("initial-wait-timeout", "refresh-timeout", "jgroups-cluster", "jgroups-channel", "jgroups-stack")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JGROUPS_DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JGROUPS_DISCOVERY_GROUP, form))
            .build();
        socketDiscoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-discovery-group-form", metadata81)
            .include("initial-wait-timeout", "refresh-timeout", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.SOCKET_DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.SOCKET_DISCOVERY_GROUP, form))
            .build();
        socketDiscoveryGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        clusterConnectionForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-form", metadata82)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CLUSTER_CONNECTION, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CLUSTER_CONNECTION, form))
            .build();
        groupingHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-form", metadata83)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.GROUPING_HANDLER, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.GROUPING_HANDLER, form))
            .build();

        jgroupsBroadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-broadcast-group-table", metadata78)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JGROUPS_BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JGROUPS_BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        socketBroadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-broadcast-group-table", metadata79)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.SOCKET_BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.SOCKET_BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jgroupsDiscoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jgroups-discovery-group-table", metadata80)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JGROUPS_DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JGROUPS_DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jgroups-discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        socketDiscoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-socket-discovery-group-table", metadata81)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.SOCKET_DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.SOCKET_DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/socket-discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        clusterConnectionTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-table", metadata82)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClusterConnection(ServerSubResource.CLUSTER_CONNECTION), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CLUSTER_CONNECTION, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        groupingHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-table", metadata83)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.GROUPING_HANDLER), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.GROUPING_HANDLER, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-broadcast-group-item", "Broadcast Group", "fa fa-video-camera");
        HTMLElement html224;
        HTMLElement msgJgroupsBroadcastGroupItemElement = section()
            .add(html224 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JGroups Broadcast Group</h1><p>${metadata78.getDescription().getDescription()}</p>"))
                                    .element())
            .add(jgroupsBroadcastGroupTable)
            .add(jgroupsBroadcastGroupForm)
                            .element();
        expressionElements.put("html224", html224);
        navigation.addSecondary("messaging-broadcast-group-item", "msg-jgroups-broadcast-group-item", "JGroups Broadcast Group", msgJgroupsBroadcastGroupItemElement);
        HTMLElement html227;
        HTMLElement msgSocketBroadcastGroupItemElement = section()
            .add(html227 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Broadcast Group</h1><p>${metadata79.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketBroadcastGroupTable)
            .add(socketBroadcastGroupForm)
                            .element();
        expressionElements.put("html227", html227);
        navigation.addSecondary("messaging-broadcast-group-item", "msg-socket-broadcast-group-item", "Socket Broadcast Group", msgSocketBroadcastGroupItemElement);
        navigation.addPrimary("messaging-discovery-group-item", "Discovery Group", "fa fa-map-o");
        HTMLElement html230;
        HTMLElement msgJgroupsDiscoveryGroupItemElement = section()
            .add(html230 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JGroups Discovery Group</h1><p>${metadata80.getDescription().getDescription()}</p>"))
                                    .element())
            .add(jgroupsDiscoveryGroupTable)
            .add(jgroupsDiscoveryGroupForm)
                            .element();
        expressionElements.put("html230", html230);
        navigation.addSecondary("messaging-discovery-group-item", "msg-jgroups-discovery-group-item", "JGroups Discovery Group", msgJgroupsDiscoveryGroupItemElement);
        HTMLElement html233;
        HTMLElement msgSocketDiscoveryGroupItemElement = section()
            .add(html233 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Discovery Group</h1><p>${metadata81.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketDiscoveryGroupTable)
            .add(socketDiscoveryGroupForm)
                            .element();
        expressionElements.put("html233", html233);
        navigation.addSecondary("messaging-discovery-group-item", "msg-socket-discovery-group-item", "Socket Discovery Group", msgSocketDiscoveryGroupItemElement);
        HTMLElement html236;
        HTMLElement messagingClusterConnectionItemElement = section()
            .add(html236 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cluster Connection</h1><p>${metadata82.getDescription().getDescription()}</p>"))
                            .element())
            .add(clusterConnectionTable)
            .add(clusterConnectionForm)
                    .element();
        expressionElements.put("html236", html236);
        navigation.addPrimary("messaging-cluster-connection-item", "Cluster Connection", "pficon pficon-network", messagingClusterConnectionItemElement);
        HTMLElement html239;
        HTMLElement messagingGroupingHandlerItemElement = section()
            .add(html239 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Grouping Handler</h1><p>${metadata83.getDescription().getDescription()}</p>"))
                            .element())
            .add(groupingHandlerTable)
            .add(groupingHandlerForm)
                    .element();
        expressionElements.put("html239", html239);
        navigation.addPrimary("messaging-grouping-handler-item", "Grouping Handler", "fa fa-object-group", messagingGroupingHandlerItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(jgroupsBroadcastGroupTable);
        registerAttachable(socketBroadcastGroupTable);
        registerAttachable(jgroupsBroadcastGroupForm);
        registerAttachable(socketBroadcastGroupForm);
        registerAttachable(jgroupsDiscoveryGroupTable);
        registerAttachable(socketDiscoveryGroupTable);
        registerAttachable(jgroupsDiscoveryGroupForm);
        registerAttachable(socketDiscoveryGroupForm);
        registerAttachable(clusterConnectionTable);
        registerAttachable(clusterConnectionForm);
        registerAttachable(groupingHandlerTable);
        registerAttachable(groupingHandlerForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            jgroupsBroadcastGroupTable.bindForm(jgroupsBroadcastGroupForm);
            socketBroadcastGroupTable.bindForm(socketBroadcastGroupForm);
            jgroupsDiscoveryGroupTable.bindForm(jgroupsDiscoveryGroupForm);
            socketDiscoveryGroupTable.bindForm(socketDiscoveryGroupForm);
            clusterConnectionTable.bindForm(clusterConnectionForm);
            groupingHandlerTable.bindForm(groupingHandlerForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html224"), "${metadata78.getDescription().getDescription()}", String.valueOf(metadata78.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html227"), "${metadata79.getDescription().getDescription()}", String.valueOf(metadata79.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html230"), "${metadata80.getDescription().getDescription()}", String.valueOf(metadata80.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html233"), "${metadata81.getDescription().getDescription()}", String.valueOf(metadata81.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html236"), "${metadata82.getDescription().getDescription()}", String.valueOf(metadata82.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html239"), "${metadata83.getDescription().getDescription()}", String.valueOf(metadata83.getDescription().getDescription()));
    }
}
