package org.jboss.hal.client.configuration.subsystem.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemotingView extends RemotingView {

    private final Metadata metadata118;
    private final Metadata metadata116;
    private final Metadata metadata115;
    private final Metadata metadata117;
    private final Metadata metadata114;
    private final Metadata metadata119;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemotingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata118Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/outbound-connection=*");
        this.metadata118 = mbuiContext.metadataRegistry().lookup(metadata118Template);
        AddressTemplate metadata116Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*");
        this.metadata116 = mbuiContext.metadataRegistry().lookup(metadata116Template);
        AddressTemplate metadata115Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*");
        this.metadata115 = mbuiContext.metadataRegistry().lookup(metadata115Template);
        AddressTemplate metadata117Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/local-outbound-connection=*");
        this.metadata117 = mbuiContext.metadataRegistry().lookup(metadata117Template);
        AddressTemplate metadata114Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting");
        this.metadata114 = mbuiContext.metadataRegistry().lookup(metadata114Template);
        AddressTemplate metadata119Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/remote-outbound-connection=*");
        this.metadata119 = mbuiContext.metadataRegistry().lookup(metadata119Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("remoting-configuration", metadata114)
            .customGroup("remoting-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("buffer-region-size", "heartbeat-interval", "receive-buffer-size", "receive-window-size", "send-buffer-size", "server-name", "transmit-window-size", "worker")
            .end()
            .customGroup("remoting-configuration-security", "Security")
                .include("auth-realm", "authentication-retries", "authorize-id", "sasl-protocol")
            .end()
            .customGroup("remoting-configuration-channels", "Channels")
                .include("max-inbound-channels", "max-inbound-message-size", "max-inbound-messages", "max-outbound-channels", "max-outbound-message-size", "max-outbound-messages")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata114Template.resolve(statementContext()), changedValues, metadata114))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata114Template.resolve(statementContext()), form, metadata114))
            .build();
        localOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-form", metadata117)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("outbound-socket-binding-ref")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveLocalOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetLocalOutbound(form))
            .build();
        localOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
        outboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-form", metadata118)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("uri")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetOutbound(form))
            .build();
        remoteOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-form", metadata119)
            .include("authentication-context")
            .include("outbound-socket-binding-ref")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveRemoteOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetRemoteOutbound(form))
            .build();
        remoteOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-connector-table", metadata115)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-connector-table", Ids.ADD), "Connector",
                metadata115Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Connector", metadata115Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-http-connector-table", metadata116)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-http-connector-table", Ids.ADD), "HTTP Connector",
                metadata116Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("HTTP Connector", metadata116Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        localOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-table", metadata117)
            .button(mbuiContext.tableButtonFactory().add(metadata117Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-local-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Local Outbound"),
                    metadata117,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata117Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Local Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Local Outbound", metadata117Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-table", metadata118)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-outbound-table", Ids.ADD), "Outbound",
                metadata118Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Outbound", metadata118Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-table", metadata119)
            .button(mbuiContext.tableButtonFactory().add(metadata119Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-remote-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Remote Outbound"),
                    metadata119,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata119Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Remote Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Remote Outbound", metadata119Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html336;
        HTMLElement remotingConfigurationItemElement = section()
            .add(html336 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata114.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html336", html336);
        navigation.addPrimary("remoting-configuration-item", "Configuration", "pficon pficon-settings", remotingConfigurationItemElement);
        navigation.addPrimary("remoting-remote-connector-item", "Remote Connector", "pficon pficon-network");
        HTMLElement html338;
        HTMLElement remotingConnectorSubItemElement = section()
            .add(html338 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector</h1><p>${metadata115.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
                            .element();
        expressionElements.put("html338", html338);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-connector-sub-item", "Connector", remotingConnectorSubItemElement);
        HTMLElement html340;
        HTMLElement remotingHttpConnectorSubItemElement = section()
            .add(html340 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata116.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
                            .element();
        expressionElements.put("html340", html340);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-http-connector-sub-item", "HTTP Connector", remotingHttpConnectorSubItemElement);
        navigation.addPrimary("remoting-outbound-connection-item", "Outbound Connection", "pficon pficon-service");
        HTMLElement html342;
        HTMLElement remotingLocalOutboundSubItemElement = section()
            .add(html342 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Local Outbound</h1><p>${metadata117.getDescription().getDescription()}</p>"))
                                    .element())
            .add(localOutboundTable)
            .add(localOutboundForm)
                            .element();
        expressionElements.put("html342", html342);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-local-outbound-sub-item", "Local Outbound", remotingLocalOutboundSubItemElement);
        HTMLElement html345;
        HTMLElement remotingOutboundSubItemElement = section()
            .add(html345 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound</h1><p>${metadata118.getDescription().getDescription()}</p>"))
                                    .element())
            .add(outboundTable)
            .add(outboundForm)
                            .element();
        expressionElements.put("html345", html345);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-outbound-sub-item", "Outbound", remotingOutboundSubItemElement);
        HTMLElement html348;
        HTMLElement remotingRemoteOutboundSubItemElement = section()
            .add(html348 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Outbound</h1><p>${metadata119.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteOutboundTable)
            .add(remoteOutboundForm)
                            .element();
        expressionElements.put("html348", html348);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-remote-outbound-sub-item", "Remote Outbound", remotingRemoteOutboundSubItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(connectorTable);
        registerAttachable(httpConnectorTable);
        registerAttachable(localOutboundTable);
        registerAttachable(localOutboundForm);
        registerAttachable(outboundTable);
        registerAttachable(outboundForm);
        registerAttachable(remoteOutboundTable);
        registerAttachable(remoteOutboundForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            localOutboundTable.bindForm(localOutboundForm);
            outboundTable.bindForm(outboundForm);
            remoteOutboundTable.bindForm(remoteOutboundForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html336"), "${metadata114.getDescription().getDescription()}", String.valueOf(metadata114.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html338"), "${metadata115.getDescription().getDescription()}", String.valueOf(metadata115.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html340"), "${metadata116.getDescription().getDescription()}", String.valueOf(metadata116.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html342"), "${metadata117.getDescription().getDescription()}", String.valueOf(metadata117.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html345"), "${metadata118.getDescription().getDescription()}", String.valueOf(metadata118.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html348"), "${metadata119.getDescription().getDescription()}", String.valueOf(metadata119.getDescription().getDescription()));
    }
}
