/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.fraction.runtime;

import java.net.URL;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.hal.fraction.HalFraction;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.wildfly.swarm.spi.api.ArtifactLookup;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.undertow.WARArchive;

public class HalDeploymentProducer {
    @Inject
    private ArtifactLookup lookup;
    @Inject
    @Any
    private HalFraction fraction;
    @Inject
    @ConfigurationValue(value="swarm.management.hal.context")
    private String context;

    @Produces
    public Archive managementConsoleWar() throws Exception {
        if (this.context == null) {
            this.context = this.fraction.contextRoot();
        }
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.hal"));
        URL resource = module.getExportedResource("hal-console-resources.jar");
        WARArchive war = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)"hal-console.war");
        ((ZipImporter)war.as(ZipImporter.class)).importFrom(resource.openStream());
        war.setContextRoot(this.context);
        return war;
    }
}

