/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.hal.processor.mbui.Attribute;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementInfo;
import org.jboss.hal.processor.mbui.MetadataInfo;

public class FormInfo
extends MbuiElementInfo {
    private final String typeParameter;
    private final MetadataInfo metadata;
    private final String title;
    private final boolean autoSave;
    private final String onSave;
    private final String nameResolver;
    private final List<Attribute> attributes;

    FormInfo(String name, String selector, String typeParameter, MetadataInfo metadata, String title, boolean autoSave, String onSave, String nameResolver) {
        super(name, selector);
        this.typeParameter = typeParameter;
        this.metadata = metadata;
        this.title = Handlebars.templateSafeValue(title);
        this.autoSave = autoSave;
        this.onSave = Handlebars.stripHandlebar(onSave);
        this.nameResolver = Handlebars.stripHandlebar(nameResolver);
        this.attributes = new ArrayList<Attribute>();
    }

    public String getTypeParameter() {
        return this.typeParameter;
    }

    public MetadataInfo getMetadata() {
        return this.metadata;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public String getOnSave() {
        return this.onSave;
    }

    public String getNameResolver() {
        return this.nameResolver;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean isHasAttributesWithProvider() {
        for (Attribute attribute : this.attributes) {
            if (attribute.getProvider() == null) continue;
            return true;
        }
        return false;
    }

    public List<Attribute> getValidationHandlerAttributes() {
        return this.attributes.stream().filter(attribute -> attribute.getValidationHandler() != null).collect(Collectors.toList());
    }

    public List<Attribute> getSuggestHandlerAttributes() {
        return this.attributes.stream().filter(attribute -> attribute.getSuggestHandler() != null || !attribute.getSuggestHandlerTemplates().isEmpty()).collect(Collectors.toList());
    }

    void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }
}

