/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import com.google.common.base.Strings;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Types;
import org.jboss.hal.ballroom.LabelBuilder;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.processor.mbui.AbstractMbuiElementProcessor;
import org.jboss.hal.processor.mbui.FormInfo;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementProcessor;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MbuiViewProcessor;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jdom2.Element;
import org.jdom2.xpath.XPathFactory;

class FormProcessor
extends AbstractMbuiElementProcessor
implements MbuiElementProcessor {
    private static final String ON_SAVE_SIGNATURE = "(form, changedValues)";

    FormProcessor(MbuiViewProcessor processor, Types typeUtils, XPathFactory xPathFactory) {
        super(processor, typeUtils, xPathFactory);
    }

    @Override
    public void process(VariableElement field, Element element, String selector, MbuiViewContext context) {
        String title = element.getAttributeValue("title");
        boolean autoSave = Boolean.parseBoolean(element.getAttributeValue("auto-save"));
        String onSave = element.getAttributeValue("on-save");
        String nameResolver = element.getAttributeValue("name-resolver");
        MetadataInfo metadata = this.findMetadata(field, element, context);
        AddressTemplate template = AddressTemplate.of((String)metadata.getTemplate());
        if (autoSave && !Strings.isNullOrEmpty((String)onSave)) {
            this.processor.error(field, "Please choose either auto-save or on-save not both.", new Object[0]);
        } else if (autoSave) {
            if (title == null) {
                title = new LabelBuilder().label(template.lastKey());
            }
            if (nameResolver != null && !Handlebars.isExpression(nameResolver)) {
                this.processor.error(field, "Name resolver in form#%s has to be an expression.", new Object[]{selector});
            }
            if ("*".equals(template.lastValue()) && nameResolver == null) {
                this.processor.error(field, "Auto save is enabled for form#%s and related metadata address ends in \"*\", but no name resolver is is provided.", new Object[]{selector});
            }
        } else if (!Strings.isNullOrEmpty((String)onSave)) {
            if (!Handlebars.isExpression(onSave)) {
                this.processor.error(field, "on-save handler in form#%s has to be an expression.", new Object[]{selector});
            }
            if (!onSave.contains(ON_SAVE_SIGNATURE)) {
                this.processor.error(field, "Invalid signature for on-save handler in form#%s. Signature has to follow \"%s\".", new Object[]{selector, ON_SAVE_SIGNATURE});
            }
        }
        FormInfo formInfo = new FormInfo(field.getSimpleName().toString(), selector, this.getTypeParameter(field), metadata, title, autoSave, onSave, nameResolver);
        context.addFormInfo(formInfo);
        Element attributesContainer = element.getChild("attributes");
        if (attributesContainer != null) {
            this.processAttributes(field, attributesContainer).forEach(formInfo::addAttribute);
        }
    }
}

