/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.jboss.auto.AbstractProcessor;
import org.jboss.gwt.circuit.meta.Store;

@SupportedAnnotationTypes(value={"org.jboss.gwt.circuit.meta.Store"})
@AutoService(value=Processor.class)
public class StoreInitProcessor
extends AbstractProcessor {
    private static final String ADAPTER_SUFFIX = "Adapter";
    private static final String STORE_MODULE_TEMPLATE = "StoreModule.ftl";
    private static final String STORE_MODULE_PACKAGE = "org.jboss.hal.client.gin";
    private static final String STORE_MODULE_CLASS = "StoreModule";
    private final Set<StoreInfo> storeInfos = new HashSet<StoreInfo>();

    public StoreInitProcessor() {
        super(StoreInitProcessor.class, "templates");
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Store.class)) {
            TypeElement storeElement = (TypeElement)element;
            PackageElement packageElement = (PackageElement)storeElement.getEnclosingElement();
            String packageName = packageElement.getQualifiedName().toString();
            String storeDelegate = storeElement.getSimpleName().toString();
            String storeAdapter = storeDelegate + ADAPTER_SUFFIX;
            StoreInfo storeInfo = new StoreInfo(packageName, storeDelegate, storeAdapter);
            this.storeInfos.add(storeInfo);
            this.debug("Discovered store / store adapter [%s]", new Object[]{storeInfo});
        }
        if (!this.storeInfos.isEmpty()) {
            this.debug("Generating code for store module", new Object[0]);
            this.code(STORE_MODULE_TEMPLATE, STORE_MODULE_PACKAGE, STORE_MODULE_CLASS, () -> {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("generatedWith", StoreInitProcessor.class.getName());
                context.put("packageName", STORE_MODULE_PACKAGE);
                context.put("className", STORE_MODULE_CLASS);
                context.put("storeInfos", this.storeInfos);
                return context;
            });
            this.info("Successfully generated store initialization class [%s].", new Object[]{STORE_MODULE_CLASS});
            this.storeInfos.clear();
        }
        return false;
    }

    public static final class StoreInfo {
        private final String packageName;
        private final String storeDelegate;
        private final String storeAdapter;

        StoreInfo(String packageName, String storeDelegate, String storeAdapter) {
            this.packageName = packageName;
            this.storeDelegate = storeDelegate;
            this.storeAdapter = storeAdapter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StoreInfo)) {
                return false;
            }
            StoreInfo storeInfo = (StoreInfo)o;
            if (!this.packageName.equals(storeInfo.packageName)) {
                return false;
            }
            if (!this.storeDelegate.equals(storeInfo.storeDelegate)) {
                return false;
            }
            return this.storeAdapter.equals(storeInfo.storeAdapter);
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = 31 * result + this.storeDelegate.hashCode();
            result = 31 * result + this.storeAdapter.hashCode();
            return result;
        }

        public String toString() {
            return this.storeDelegate + " / " + this.storeAdapter;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getStoreAdapter() {
            return this.storeAdapter;
        }

        public String getStoreDelegate() {
            return this.storeDelegate;
        }
    }
}

