/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Handlebars {
    private static final Pattern PATTERN = Pattern.compile("\\{\\{(.*?)\\}\\}");

    private Handlebars() {
    }

    static Map<String, String> parse(String input) {
        if (input != null) {
            HashMap<String, String> matches = new HashMap<String, String>();
            Matcher matcher = PATTERN.matcher(input);
            while (matcher.find()) {
                String match = matcher.group();
                Handlebars.validate(match);
                matches.put(match, Handlebars.stripHandlebar(match));
            }
            return matches;
        }
        return Collections.emptyMap();
    }

    private static void validate(String pattern) {
        if (!Handlebars.isExpression(pattern)) {
            throw new IllegalArgumentException("Invalid handlebar pattern: " + pattern);
        }
        if (pattern.lastIndexOf("{{") != 0 || pattern.indexOf("}}") != pattern.length() - 2) {
            throw new IllegalArgumentException("Invalid handlebar pattern: " + pattern);
        }
    }

    static boolean isExpression(String value) {
        return value != null && value.startsWith("{{") && value.endsWith("}}");
    }

    static String stripHandlebar(String pattern) {
        if (Handlebars.isExpression(pattern)) {
            int start = "{{".length();
            int end = pattern.length() - "}}".length();
            return pattern.substring(start, end);
        }
        return pattern;
    }

    static String templateSafeValue(String value) {
        if (value != null) {
            return Handlebars.isExpression(value) ? Handlebars.stripHandlebar(value) : "\"" + value + "\"";
        }
        return null;
    }
}

