/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.hal.processor.mbui.Attribute;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementInfo;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.TypeParameter;

public class FormInfo
extends MbuiElementInfo {
    private final TypeParameter typeParameter;
    private final MetadataInfo metadata;
    private final String title;
    private final boolean autoSave;
    private final String onSave;
    private final String nameResolver;
    private final boolean includeRuntime;
    private final boolean failSafe;
    private final List<Attribute> attributes;
    private final List<Group> groups;

    FormInfo(String name, String selector, TypeParameter typeParameter, MetadataInfo metadata, String title, boolean autoSave, String onSave, String nameResolver, boolean includeRuntime, boolean failSafe) {
        super(name, selector);
        this.typeParameter = typeParameter;
        this.metadata = metadata;
        this.title = Handlebars.templateSafeValue(title);
        this.autoSave = autoSave;
        this.onSave = Handlebars.stripHandlebar(onSave);
        this.nameResolver = Handlebars.stripHandlebar(nameResolver);
        this.includeRuntime = includeRuntime;
        this.failSafe = failSafe;
        this.attributes = new ArrayList<Attribute>();
        this.groups = new ArrayList<Group>();
    }

    public TypeParameter getTypeParameter() {
        return this.typeParameter;
    }

    public MetadataInfo getMetadata() {
        return this.metadata;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public String getOnSave() {
        return this.onSave;
    }

    public String getNameResolver() {
        return this.nameResolver;
    }

    public boolean isIncludeRuntime() {
        return this.includeRuntime;
    }

    public boolean isFailSafe() {
        return this.failSafe;
    }

    void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean isHasAttributesWithProvider() {
        for (Attribute attribute : this.attributes) {
            if (attribute.getProvider() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasUnboundAttributes() {
        for (Attribute attribute : this.attributes) {
            if (attribute.getFormItem() == null) continue;
            return true;
        }
        return false;
    }

    public List<Attribute> getValidationHandlerAttributes() {
        if (this.groups.isEmpty()) {
            return this.attributes.stream().filter(attribute -> attribute.getValidationHandler() != null).collect(Collectors.toList());
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        this.groups.forEach(group -> group.getAttributes().stream().filter(attribute -> attribute.getValidationHandler() != null).forEach(attributes::add));
        return attributes;
    }

    public List<Attribute> getSuggestHandlerAttributes() {
        if (this.groups.isEmpty()) {
            return this.attributes.stream().filter(attribute -> attribute.getSuggestHandler() != null || !attribute.getSuggestHandlerTemplates().isEmpty()).collect(Collectors.toList());
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        this.groups.forEach(group -> group.getAttributes().stream().filter(attribute -> attribute.getSuggestHandler() != null || !attribute.getSuggestHandlerTemplates().isEmpty()).forEach(attributes::add));
        return attributes;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    void addGroup(Group group) {
        this.groups.add(group);
    }

    public static class Group {
        private final String id;
        private final String title;
        private final List<Attribute> attributes;

        Group(String id, String title) {
            this.id = id;
            this.title = Handlebars.templateSafeValue(title);
            this.attributes = new ArrayList<Attribute>();
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        void addAttribute(Attribute attribute) {
            this.attributes.add(attribute);
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public boolean isHasAttributesWithProvider() {
            for (Attribute attribute : this.attributes) {
                if (attribute.getProvider() == null) continue;
                return true;
            }
            return false;
        }

        public boolean isHasUnboundAttributes() {
            for (Attribute attribute : this.attributes) {
                if (attribute.getFormItem() == null) continue;
                return true;
            }
            return false;
        }
    }
}

