/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import com.google.common.base.Strings;
import java.util.List;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.hal.ballroom.LabelBuilder;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.processor.mbui.AbstractMbuiElementProcessor;
import org.jboss.hal.processor.mbui.FormInfo;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementProcessor;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MbuiViewProcessor;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jdom2.Element;
import org.jdom2.xpath.XPathFactory;

class FormProcessor
extends AbstractMbuiElementProcessor
implements MbuiElementProcessor {
    FormProcessor(MbuiViewProcessor processor, Types typeUtils, Elements elementUtils, XPathFactory xPathFactory) {
        super(processor, typeUtils, elementUtils, xPathFactory);
    }

    @Override
    public void process(VariableElement field, Element element, String selector, MbuiViewContext context) {
        String title = element.getAttributeValue("title");
        boolean autoSave = Boolean.parseBoolean(element.getAttributeValue("auto-save"));
        boolean includeRuntime = Boolean.parseBoolean(element.getAttributeValue("include-runtime"));
        boolean failSafe = "fail-safe-form".equalsIgnoreCase(element.getName());
        String onSave = element.getAttributeValue("on-save");
        String nameResolver = element.getAttributeValue("name-resolver");
        MetadataInfo metadata = this.findMetadata(field, element, context);
        AddressTemplate template = AddressTemplate.of((String)metadata.getTemplate());
        if (autoSave && !Strings.isNullOrEmpty((String)onSave)) {
            this.processor.error(field, "Please choose either auto-save or on-save not both.", new Object[0]);
        } else if (autoSave) {
            if (title == null) {
                title = new LabelBuilder().label(template.lastKey());
            }
            if (nameResolver != null && !Handlebars.isExpression(nameResolver)) {
                this.processor.error(field, "Name resolver in form#%s has to be an expression.", new Object[]{selector});
            }
            if ("*".equals(template.lastValue()) && nameResolver == null) {
                this.processor.error(field, "Auto save is enabled for form#%s and related metadata address ends in \"*\", but no name resolver is is provided.", new Object[]{selector});
            }
        } else if (!Strings.isNullOrEmpty((String)onSave) && !Handlebars.isExpression(onSave)) {
            this.processor.error(field, "on-save handler in form#%s has to be an expression.", new Object[]{selector});
        }
        FormInfo formInfo = new FormInfo(field.getSimpleName().toString(), selector, this.getTypeParameter(field), metadata, title, autoSave, onSave, nameResolver, includeRuntime, failSafe);
        context.addFormInfo(formInfo);
        Element attributesContainer = element.getChild("attributes");
        if (attributesContainer != null) {
            List groupElements = attributesContainer.getChildren("group");
            if (groupElements.isEmpty()) {
                this.processAttributes(field, attributesContainer).forEach(formInfo::addAttribute);
            } else {
                for (Element groupElement : groupElements) {
                    String id = groupElement.getAttributeValue("id");
                    String name = groupElement.getAttributeValue("name");
                    String groupTitle = groupElement.getAttributeValue("title");
                    FormInfo.Group group = new FormInfo.Group(id, name, groupTitle);
                    groupElement.getChildren("attribute").forEach(attributeElement -> group.addAttribute(this.processAttribute(field, (Element)attributeElement)));
                    formInfo.addGroup(group);
                }
            }
        }
    }
}

