/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor;

import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class TypeSimplifier {
    public static String classNameOf(TypeElement type) {
        String name = type.getQualifiedName().toString();
        String pkgName = TypeSimplifier.packageNameOf(type);
        return pkgName.isEmpty() ? name : name.substring(pkgName.length() + 1);
    }

    public static String packageNameOf(TypeElement type) {
        Element enclosing;
        while (!((enclosing = type.getEnclosingElement()) instanceof PackageElement)) {
            type = (TypeElement)enclosing;
        }
        return ((PackageElement)enclosing).getQualifiedName().toString();
    }

    public static String simpleNameOf(String s) {
        if (s.contains(".")) {
            return s.substring(s.lastIndexOf(46) + 1);
        }
        return s;
    }

    public static String simpleTypeName(TypeMirror type) {
        String name = type.toString();
        if (name.startsWith("java.lang.")) {
            return name.substring("java.lang.".length());
        }
        return name;
    }
}

