/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.processor.mbui.Attribute;
import org.jboss.hal.processor.mbui.FormInfo;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementInfo;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.TypeParameter;

public class DataTableInfo
extends MbuiElementInfo {
    private final TypeParameter typeParameter;
    private final MetadataInfo metadata;
    private final String title;
    private FormInfo formRef;
    private final List<Column> columns;
    private final List<Action> actions;

    DataTableInfo(String name, String selector, TypeParameter typeParameter, MetadataInfo metadata, String title) {
        super(name, selector);
        this.typeParameter = typeParameter;
        this.metadata = metadata;
        this.title = Handlebars.templateSafeValue(title);
        this.columns = new ArrayList<Column>();
        this.actions = new ArrayList<Action>();
    }

    public TypeParameter getTypeParameter() {
        return this.typeParameter;
    }

    public MetadataInfo getMetadata() {
        return this.metadata;
    }

    public String getTitle() {
        return this.title;
    }

    public FormInfo getFormRef() {
        return this.formRef;
    }

    void setFormRef(FormInfo formRef) {
        this.formRef = formRef;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public boolean isOnlySimpleColumns() {
        for (Column column : this.columns) {
            if (column.getValue() == null) continue;
            return false;
        }
        return true;
    }

    void addColumn(Column column) {
        this.columns.add(column);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    void addAction(Action action) {
        this.actions.add(action);
    }

    public static class Column {
        private final String name;
        private final String value;

        Column(String name, String value) {
            this.name = name;
            this.value = Handlebars.stripHandlebar(value);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Action {
        private final String handler;
        private final HandlerRef handlerRef;
        private final String title;
        private final Button.Scope scope;
        private final String constraint;
        private final String nameResolver;
        private final List<Attribute> attributes;

        public Action(String handler, String title, String scope, String constraint, String nameResolver) {
            this.handler = Handlebars.stripHandlebar(handler);
            this.handlerRef = HandlerRef.referenceFor(handler);
            this.title = Handlebars.templateSafeValue(title);
            this.scope = scope != null ? Button.Scope.valueOf((String)scope.toUpperCase()) : null;
            this.constraint = constraint;
            this.nameResolver = Handlebars.stripHandlebar(nameResolver);
            this.attributes = new ArrayList<Attribute>();
        }

        public String getHandler() {
            return this.handler;
        }

        public boolean isKnownHandler() {
            return this.handlerRef != null;
        }

        public HandlerRef getHandlerRef() {
            return this.handlerRef;
        }

        public String getTitle() {
            return this.title;
        }

        public Button.Scope getScope() {
            return this.scope;
        }

        public String getConstraint() {
            return this.constraint;
        }

        public String getNameResolver() {
            return this.nameResolver;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public boolean isHasAttributesWithProvider() {
            for (Attribute attribute : this.attributes) {
                if (attribute.getProvider() == null) continue;
                return true;
            }
            return false;
        }

        public boolean isHasUnboundAttributes() {
            for (Attribute attribute : this.attributes) {
                if (attribute.getFormItem() == null) continue;
                return true;
            }
            return false;
        }

        public boolean isHasAttributesWithValidationsHandler() {
            return !this.getSuggestHandlerAttributes().isEmpty();
        }

        public List<Attribute> getValidationHandlerAttributes() {
            return this.attributes.stream().filter(attribute -> attribute.getValidationHandler() != null).collect(Collectors.toList());
        }

        public boolean isHasAttributesWithSuggestionHandler() {
            return !this.getSuggestHandlerAttributes().isEmpty();
        }

        public List<Attribute> getSuggestHandlerAttributes() {
            return this.attributes.stream().filter(attribute -> attribute.getSuggestHandler() != null || !attribute.getSuggestHandlerTemplates().isEmpty()).collect(Collectors.toList());
        }

        void addAttribute(Attribute attribute) {
            this.attributes.add(attribute);
        }
    }

    public static enum HandlerRef {
        ADD_RESOURCE("add-resource", "add()"),
        REMOVE_RESOURCE("remove-resource", "remove()");

        private final String ref;
        private final String i18n;

        static HandlerRef referenceFor(String value) {
            for (HandlerRef ref : HandlerRef.values()) {
                if (!ref.getRef().equals(value)) continue;
                return ref;
            }
            return null;
        }

        private HandlerRef(String ref, String i18n) {
            this.ref = ref;
            this.i18n = i18n;
        }

        public String getRef() {
            return this.ref;
        }

        public String getI18n() {
            return this.i18n;
        }
    }
}

