/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.hal.processor.mbui.Content;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementInfo;

public class VerticalNavigationInfo
extends MbuiElementInfo {
    private final List<Item> items = new ArrayList<Item>();
    private final Map<String, Item> itemsById = new HashMap<String, Item>();

    VerticalNavigationInfo(String name, String selector) {
        super(name, selector);
    }

    public List<Item> getItems() {
        return this.items;
    }

    void addItem(Item item) {
        this.items.add(item);
        this.itemsById.put(item.getId(), item);
    }

    Item getItem(String id) {
        Item item = this.itemsById.get(id);
        if (item == null) {
            for (Item itm : this.items) {
                Item subItem = itm.getItem(id);
                if (subItem == null) continue;
                return subItem;
            }
        }
        return item;
    }

    public static class Item {
        private final String id;
        private final String name;
        private final String title;
        private final String icon;
        private final List<Content> content;
        private final List<Item> subItems;
        private final Map<String, Item> subItemsById;

        Item(String id, String title, String icon) {
            this.id = id;
            this.name = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, id);
            this.title = Handlebars.templateSafeValue(title);
            this.icon = icon;
            this.content = new ArrayList<Content>();
            this.subItems = new ArrayList<Item>();
            this.subItemsById = new HashMap<String, Item>();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getIcon() {
            return this.icon;
        }

        public List<Item> getSubItems() {
            return this.subItems;
        }

        void addSubItem(Item subItem) {
            this.subItems.add(subItem);
            this.subItemsById.put(subItem.getId(), subItem);
        }

        Item getItem(String id) {
            return this.subItemsById.get(id);
        }

        public List<Content> getContent() {
            return this.content;
        }

        public List<Content> getHtmlContent() {
            return this.content.stream().filter(c -> c.getHtml() != null).collect(Collectors.toList());
        }

        void addContent(Content content) {
            this.content.add(content);
        }

        Content findContent(String id) {
            for (Content c : this.content) {
                if (!id.equals(c.getReference())) continue;
                return c;
            }
            return null;
        }
    }
}

