/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor;

import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import org.jboss.auto.AbstractProcessor;
import org.jboss.hal.core.Strings;
import org.jboss.hal.spi.EsParam;
import org.jboss.hal.spi.EsReturn;

@SupportedAnnotationTypes(value={"jsinterop.annotations.JsType"})
public class EsDocProcessor
extends AbstractProcessor {
    private static final String AUTO = "<auto>";
    private static final String PACKAGE = "esdoc";
    private static final String PADDING = "    ";
    private static final String PARAM_TAG = "@param";
    private static final String RETURN_TAG = "@return";
    private static final String TEMPLATE = "EsDoc.ftl";
    private static final String TYPES = "types";
    private final Multimap<String, Type> types = HashMultimap.create();

    public EsDocProcessor() {
        super(EsDocProcessor.class, "templates");
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(JsType.class)) {
            TypeElement typeElement;
            PackageElement packageElement;
            JsType jsType = element.getAnnotation(JsType.class);
            if (jsType.isNative() || !(packageElement = this.elementUtils.getPackageOf(typeElement = (TypeElement)element)).getQualifiedName().toString().startsWith("org.jboss.hal")) continue;
            Type type = new Type(this.namespace(packageElement, typeElement), this.typeName(typeElement), this.comment(typeElement, ""));
            this.types.put((Object)type.getNamespace(), (Object)type);
            this.debug("Discovered JsType [%s]", new Object[]{type});
            List<? extends Element> elements = typeElement.getEnclosedElements();
            Predicate<Element> jsRelevant = e -> e != null && e.getAnnotation(JsIgnore.class) == null && e.getModifiers().contains((Object)Modifier.PUBLIC);
            ElementFilter.constructorsIn(elements).stream().filter(jsRelevant.and(e -> e.getAnnotation(JsConstructor.class) != null)).findFirst().ifPresent(e -> type.setConstructor(new Constructor(this.parameters((ExecutableElement)e), this.comment((Element)e, PADDING))));
            ElementFilter.fieldsIn(elements).stream().filter(jsRelevant).forEach(e -> {
                boolean setter = !e.getModifiers().contains((Object)Modifier.FINAL);
                type.addProperty(new Property(this.propertyName((Element)e), this.comment((Element)e, PADDING), true, setter, this._static((Element)e)));
            });
            ElementFilter.methodsIn(elements).stream().filter(jsRelevant.and(e -> e.getAnnotation(JsProperty.class) != null)).forEach(e -> type.addProperty(new Property(this.propertyName((Element)e), this.comment((Element)e, PADDING), true, false, this._static((Element)e))));
            ElementFilter.methodsIn(elements).stream().filter(jsRelevant.and(e -> e.getAnnotation(JsProperty.class) == null)).forEach(e -> type.addMethod(new Method(this.methodName((Element)e), this.parameters((ExecutableElement)e), this.comment((Element)e, PADDING), this._static((Element)e))));
        }
        if (!this.types.isEmpty()) {
            this.types.asMap().forEach((namespace, nsTypes) -> this.resource(TEMPLATE, "esdoc." + namespace, namespace + ".es6", () -> {
                HashMap<String, Collection> context = new HashMap<String, Collection>();
                context.put(TYPES, (Collection)nsTypes);
                return context;
            }));
            this.types.clear();
        }
        return false;
    }

    private String namespace(PackageElement packageElement, TypeElement typeElement) {
        JsPackage jsPackage = packageElement.getAnnotation(JsPackage.class);
        JsType jsType = typeElement.getAnnotation(JsType.class);
        String namespace = jsPackage != null ? jsPackage.namespace() : (AUTO.equals(jsType.namespace()) ? packageElement.getQualifiedName().toString() : jsType.namespace());
        return namespace;
    }

    private String comment(Element element, String padding) {
        ArrayList parameters = new ArrayList();
        String comment = this.elementUtils.getDocComment(element);
        if (comment != null) {
            String line2;
            List lines = StreamSupport.stream(Splitter.on((char)'\n').trimResults().split((CharSequence)comment).spliterator(), false).filter(line -> !line.contains("@author") && !line.contains("@version")).map(line -> {
                String result = line;
                if (element instanceof ExecutableElement) {
                    ExecutableElement method = (ExecutableElement)element;
                    if (line.startsWith(PARAM_TAG)) {
                        String lineWithoutParam = line.substring(PARAM_TAG.length());
                        VariableElement parameter = this.getParameter(method, parameters.size());
                        if (parameter != null) {
                            EsParam esParam = parameter.getAnnotation(EsParam.class);
                            String paramType = esParam != null ? esParam.value() : this.simpleName(parameter.asType().toString());
                            result = "@param {" + paramType + "}" + lineWithoutParam;
                        }
                        parameters.add(line);
                    } else if (line.startsWith(RETURN_TAG)) {
                        EsReturn esReturn = method.getAnnotation(EsReturn.class);
                        String returnType = esReturn != null ? esReturn.value() : this.simpleName(method.getReturnType().toString());
                        result = "@return {" + returnType + "}" + line.substring(RETURN_TAG.length());
                    }
                }
                return result;
            }).map(line -> padding + " * " + line).collect(Collectors.toList());
            List reversed = Lists.reverse(lines);
            Iterator iterator = reversed.iterator();
            while (iterator.hasNext() && (line2 = (String)iterator.next()).equals(padding + " * ")) {
                iterator.remove();
            }
            if (reversed.isEmpty()) {
                comment = null;
            } else {
                comment = Lists.reverse((List)reversed).stream().collect(Collectors.joining("\n"));
                comment = "/**\n" + comment + "\n" + padding + " */";
            }
        }
        return comment;
    }

    private VariableElement getParameter(ExecutableElement method, int index) {
        List<? extends VariableElement> parameters = method.getParameters();
        return index < parameters.size() ? parameters.get(index) : null;
    }

    private String simpleName(String type) {
        String simple;
        switch (simple = type.contains(".") ? Strings.substringAfterLast((String)type, (String)".") : type) {
            case "double": 
            case "Double": 
            case "float": 
            case "Float": 
            case "int": 
            case "Integer": 
            case "long": 
            case "Long": 
            case "Number": {
                simple = "number";
                break;
            }
            case "String": {
                simple = "string";
                break;
            }
        }
        return simple;
    }

    private String typeName(Element element) {
        JsType annotation = element.getAnnotation(JsType.class);
        if (annotation != null) {
            return AUTO.equals(annotation.name()) ? element.getSimpleName().toString() : annotation.name();
        }
        return element.getSimpleName().toString();
    }

    private String propertyName(Element element) {
        JsProperty annotation = element.getAnnotation(JsProperty.class);
        if (annotation != null) {
            return AUTO.equals(annotation.name()) ? this.asProperty(element) : annotation.name();
        }
        return this.asProperty(element);
    }

    private String asProperty(Element method) {
        String simpleName = method.getSimpleName().toString();
        if (simpleName.startsWith("get") || simpleName.startsWith("set")) {
            simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, simpleName.substring(3));
        } else if (simpleName.startsWith("is")) {
            simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, simpleName.substring(2));
        }
        return simpleName;
    }

    private String methodName(Element element) {
        JsMethod annotation = element.getAnnotation(JsMethod.class);
        if (annotation != null) {
            return AUTO.equals(annotation.name()) ? element.getSimpleName().toString() : annotation.name();
        }
        return element.getSimpleName().toString();
    }

    private String parameters(ExecutableElement element) {
        return element.getParameters().stream().map(variable -> variable.getSimpleName().toString()).collect(Collectors.joining(", "));
    }

    private boolean _static(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static class Method {
        private final String name;
        private final String parameters;
        private final String comment;
        private final boolean _static;

        Method(String name, String parameters, String comment, boolean _static) {
            this.name = name;
            this.parameters = parameters;
            this.comment = comment;
            this._static = _static;
        }

        public String toString() {
            return String.format("%s(%s)", this.name, this.parameters);
        }

        public String getName() {
            return this.name;
        }

        public String getParameters() {
            return this.parameters;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isStatic() {
            return this._static;
        }
    }

    public static class Property {
        private final String name;
        private final String comment;
        private final boolean getter;
        private final boolean setter;
        private final boolean _static;

        Property(String name, String comment, boolean getter, boolean setter, boolean _static) {
            this.name = name;
            this.comment = comment;
            this.getter = getter;
            this.setter = setter;
            this._static = _static;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isGetter() {
            return this.getter;
        }

        public boolean isSetter() {
            return this.setter;
        }

        public boolean isStatic() {
            return this._static;
        }
    }

    public static class Constructor {
        private final String parameters;
        private final String comment;

        Constructor(String parameters, String comment) {
            this.parameters = parameters;
            this.comment = comment;
        }

        public String toString() {
            return String.format("(%s)", this.parameters);
        }

        public String getParameters() {
            return this.parameters;
        }

        public String getComment() {
            return this.comment;
        }
    }

    public static class Type {
        private final String namespace;
        private final String name;
        private final String comment;
        private Constructor constructor;
        private final List<Property> properties;
        private final List<Method> methods;

        Type(String namespace, String name, String comment) {
            this.namespace = namespace;
            this.name = name;
            this.comment = comment;
            this.properties = new ArrayList<Property>();
            this.methods = new ArrayList<Method>();
        }

        public String toString() {
            return String.format("%s.%s", this.namespace, this.name);
        }

        void addProperty(Property property) {
            this.properties.add(property);
        }

        void addMethod(Method method) {
            this.methods.add(method);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }

        public void setConstructor(Constructor constructor) {
            this.constructor = constructor;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public List<Method> getMethods() {
            return this.methods;
        }
    }
}

